/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.serialization.pbs.executers;

import com.gigaspaces.serialization.pbs.PbsAuditor;
import com.gigaspaces.serialization.pbs.PbsInputStream;
import com.gigaspaces.serialization.pbs.PbsOutputStream;
import com.gigaspaces.serialization.pbs.executers.AbstractPbsExecuter;
import com.gigaspaces.serialization.pbs.executers.ObjectDisposedOrDoesntExistException;
import com.j_spaces.core.exception.internal.PBSInternalSpaceException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;

public abstract class AbstractPbsExecutersBundle<T> {
    public static final byte Destruct = 0;
    public static final byte Debug = 127;
    protected static final Logger _logger = Logger.getLogger("com.gigaspaces.bridge.pbsexecuter");
    private final byte _bundleCode;
    private final String _name;
    private final AbstractPbsExecuter[] _executers;
    private final AtomicLong _idGenerator;
    private final Map<Long, T> _instancesMap;

    public AbstractPbsExecutersBundle(byte bundleCode, String name) {
        this(bundleCode, name, new ConcurrentHashMap());
    }

    public AbstractPbsExecutersBundle(byte bundleCode, String name, Map<Long, T> instancesMap) {
        this._bundleCode = bundleCode;
        this._name = name;
        this._executers = this.initExecuters();
        this._idGenerator = new AtomicLong(0L);
        this._instancesMap = instancesMap;
    }

    protected abstract AbstractPbsExecuter[] initExecuters();

    public String getName() {
        return this._name;
    }

    public long addInstance(T instance) {
        long handleId = this._idGenerator.getAndIncrement();
        if (handleId == -1L) {
            handleId = this._idGenerator.getAndIncrement();
        }
        this._instancesMap.put(handleId, instance);
        return handleId;
    }

    public long addInstance(T instance, PbsOutputStream output) {
        long handleId = this.addInstance(instance);
        output.writeLong(handleId);
        return handleId;
    }

    public T addInstance(long handleId, T instance) {
        T previous = this._instancesMap.put(handleId, instance);
        return previous;
    }

    public T getInstance(long handleId) {
        T instance = this._instancesMap.get(handleId);
        if (instance == null) {
            throw new ObjectDisposedOrDoesntExistException(this._bundleCode, handleId);
        }
        return instance;
    }

    public T readInstance(PbsInputStream input) {
        long handleId = input.readLong();
        return handleId != -1L ? (T)this.getInstance(handleId) : null;
    }

    public T removeInstance(long handleId) {
        T instance = this._instancesMap.remove(handleId);
        return instance;
    }

    public void execute(byte operationCode, long handleId, PbsInputStream input, PbsOutputStream output) throws Exception {
        switch (operationCode) {
            case 0: {
                boolean disposing = input.readBoolean();
                T instance = this.removeInstance(handleId);
                if (instance == null) break;
                this.destruct(instance, handleId, disposing, input, output);
                break;
            }
            case 127: {
                this.executeGetInstancesTableState(input, output);
                break;
            }
            default: {
                if (operationCode >= this._executers.length) {
                    throw new PBSInternalSpaceException("Bundle #" + this._bundleCode + " does not support operation #" + operationCode);
                }
                AbstractPbsExecuter executor = this._executers[operationCode];
                PbsAuditor auditor = executor.getAuditor();
                auditor.logEnter();
                try {
                    executor.execute(input, output, handleId);
                    break;
                }
                catch (Exception e) {
                    auditor.logError();
                    throw e;
                }
                finally {
                    auditor.logExit();
                }
            }
        }
    }

    public void destruct(T instance, long handleId, boolean disposing, PbsInputStream input, PbsOutputStream output) throws Exception {
    }

    public Set<Map.Entry<Long, T>> entrySet() {
        return this._instancesMap.entrySet();
    }

    private void executeGetInstancesTableState(PbsInputStream input, PbsOutputStream output) {
        boolean InstancesMapSize = false;
        boolean InstancesMapKeys = true;
        int InvokeGarbageCollection = 2;
        byte readOperation = input.readByte();
        switch (readOperation) {
            case 0: {
                output.writeInt(this._instancesMap.size());
                break;
            }
            case 1: {
                output.writeInt(this._instancesMap.size());
                Iterator<Long> iterator = this._instancesMap.keySet().iterator();
                while (iterator.hasNext()) {
                    output.writeLong(iterator.next().longValue());
                }
                break;
            }
            case 2: {
                try {
                    System.gc();
                    Thread.sleep(1000L);
                    System.gc();
                    Thread.sleep(1000L);
                    System.gc();
                    Thread.sleep(1000L);
                    System.gc();
                    Thread.sleep(1000L);
                    System.gc();
                }
                catch (InterruptedException interruptedException) {}
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized debug command " + readOperation);
            }
        }
    }
}

