/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.serialization.pbs.executers;

import com.gigaspaces.internal.classloader.ClassLoaderCache;
import com.gigaspaces.internal.classloader.IClassLoaderCacheStateListener;
import com.gigaspaces.internal.utils.collections.CopyOnUpdateMap;
import com.gigaspaces.internal.utils.collections.CopyOnUpdateSet;
import com.gigaspaces.logger.GSLogConfigLoader;
import com.gigaspaces.serialization.pbs.IDotnetProxyAssociated;
import com.gigaspaces.serialization.pbs.IThreadLocalResource;
import com.gigaspaces.serialization.pbs.PbsAuditor;
import com.gigaspaces.serialization.pbs.PbsExceptionFormatter;
import com.gigaspaces.serialization.pbs.PbsInputStream;
import com.gigaspaces.serialization.pbs.PbsOutputStream;
import com.gigaspaces.serialization.pbs.PbsStreamResource;
import com.gigaspaces.serialization.pbs.executers.AbstractPbsExecutersBundle;
import com.gigaspaces.serialization.pbs.executers.AppDomainAlreadyAssociatedException;
import com.gigaspaces.serialization.pbs.executers.admin.AdminBundle;
import com.gigaspaces.serialization.pbs.executers.callbackcheck.CallbackCheckBundle;
import com.gigaspaces.serialization.pbs.executers.dataeventsession.DataEventSessionBundle;
import com.gigaspaces.serialization.pbs.executers.eventregistration.EventRegistrationBundle;
import com.gigaspaces.serialization.pbs.executers.gsiterator.GSIteratorBundle;
import com.gigaspaces.serialization.pbs.executers.ifilterentry.IFilterEntryBundle;
import com.gigaspaces.serialization.pbs.executers.internaltest.TestBundle;
import com.gigaspaces.serialization.pbs.executers.iremotejspaceadmin.IRemoteJSpaceAdminBundle;
import com.gigaspaces.serialization.pbs.executers.ispaceproxy.ISpaceProxyBundle;
import com.gigaspaces.serialization.pbs.executers.lease.LeaseBundle;
import com.gigaspaces.serialization.pbs.executers.preparedtemplate.PreparedTemplateBundle;
import com.gigaspaces.serialization.pbs.executers.spaceiterator.SpaceIteratorBundle;
import com.gigaspaces.serialization.pbs.executers.staticbundle.StaticBundle;
import com.gigaspaces.serialization.pbs.executers.string.StringBundle;
import com.gigaspaces.serialization.pbs.executers.transaction.TransactionBundle;
import com.gigaspaces.serialization.pbs.executers.transactionmanager.TranscationManagerBundle;
import com.j_spaces.core.exception.internal.PBSInternalSpaceException;
import com.j_spaces.kernel.ClassLoaderHelper;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PbsExecuter {
    private static final Logger _logger;
    private static final PbsAuditor _auditor;
    private static final byte ISpaceProxyBundleCode = 0;
    private static final byte DataEventSessionBundleCode = 1;
    private static final byte LeaseBundleCode = 2;
    private static final byte TransactionBundleCode = 3;
    private static final byte EventRegistrationCode = 4;
    private static final byte TransactionManagerBundleCode = 5;
    private static final byte PreparedTemplateBundleCode = 6;
    private static final byte GSIteratorBundleCode = 7;
    private static final byte IRemoteJSpaceAdminBundleCode = 8;
    private static final byte CallbackCheckBundleCode = 9;
    private static final byte IFilterEntryBundleCode = 10;
    private static final byte AdminBundleCode = 11;
    private static final byte SpaceIteratorBundleCode = 12;
    private static final byte StringBundleCode = 125;
    private static final byte StaticBundleCode = 126;
    private static final byte TestBundleCode = 127;
    public static final ISpaceProxyBundle ISpaceProxyBundle;
    public static final DataEventSessionBundle DataEventSessionBundle;
    public static final LeaseBundle LeaseBundle;
    public static final TransactionBundle TransactionBundle;
    public static final EventRegistrationBundle EventRegistrationBundle;
    public static final TranscationManagerBundle TransactionManagerBundle;
    public static final PreparedTemplateBundle PreparedTemplateBundle;
    public static final GSIteratorBundle GSIteratorBundle;
    public static final SpaceIteratorBundle SpaceIteratorBundle;
    public static final IRemoteJSpaceAdminBundle IRemoteJSpaceAdminBundle;
    public static final CallbackCheckBundle CallbackCheckBundle;
    public static final IFilterEntryBundle IFilterEntryBundle;
    public static final AdminBundle AdminBundle;
    public static final StringBundle StringBundle;
    public static final StaticBundle StaticBundle;
    public static final TestBundle TestBundle;
    private static final Map<Long, Integer> classLoaderToAppDomain;
    private static final Map<Integer, Long> appDomainToClassLoader;
    private static final Set<Long> multiAssociatedClassLoader;
    private static final IClassLoaderCacheStateListener listener;

    public static synchronized void associateAppDomain(int appDomainId) throws AppDomainAlreadyAssociatedException {
        long contextCLKey;
        Long associatedClassLoaderKey = appDomainToClassLoader.get(appDomainId);
        if (associatedClassLoaderKey != null) {
            ClassLoader associatedClassLoader = ClassLoaderCache.getCache().getClassLoader(associatedClassLoaderKey);
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.severe("associating AppDomain " + appDomainId + " which is already associated to class loader " + ClassLoaderHelper.getClassLoaderLogName((ClassLoader)associatedClassLoader));
            }
            throw new AppDomainAlreadyAssociatedException(appDomainId, ClassLoaderHelper.getClassLoaderLogName((ClassLoader)associatedClassLoader));
        }
        ClassLoader contextClassLoader = ClassLoaderHelper.getContextClassLoader();
        if (contextClassLoader == null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("trying to associate an AppDomain when there's no context class loader");
            }
            PbsExecuter.adjustContextClassLoader(appDomainId);
            return;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("associating AppDomain " + appDomainId + " to class loader " + ClassLoaderHelper.getClassLoaderLogName((ClassLoader)contextClassLoader));
        }
        if (classLoaderToAppDomain.containsKey(contextCLKey = ClassLoaderCache.getCache().putClassLoader(contextClassLoader).longValue())) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("trying to associate an AppDomain " + appDomainId + " to class loader " + ClassLoaderHelper.getClassLoaderLogName((ClassLoader)contextClassLoader) + " but this class loader is already associated to AppDomain " + classLoaderToAppDomain.get(contextCLKey));
            }
            multiAssociatedClassLoader.add(contextCLKey);
        } else {
            classLoaderToAppDomain.put(contextCLKey, appDomainId);
        }
        appDomainToClassLoader.put(appDomainId, contextCLKey);
    }

    public static synchronized void dissociateAppDomain(int appDomainId) {
        Integer removedAppDomain;
        Long associatedClassLoaderKey = appDomainToClassLoader.remove(appDomainId);
        if (associatedClassLoaderKey == null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("dissociating AppDomain " + appDomainId + " which has no associated existing class loader");
            }
            return;
        }
        ClassLoader associatedClassLoader = ClassLoaderCache.getCache().getClassLoader(associatedClassLoaderKey);
        if (associatedClassLoader == null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("dissociating AppDomain " + appDomainId + " which has no cached associated existing class loader [" + associatedClassLoaderKey + "]");
            }
            return;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("dissociating AppDomain " + appDomainId + " from class loader " + ClassLoaderHelper.getClassLoaderLogName((ClassLoader)associatedClassLoader));
        }
        if ((removedAppDomain = classLoaderToAppDomain.remove(associatedClassLoaderKey)) == null && _logger.isLoggable(Level.FINE)) {
            _logger.fine("class loader " + ClassLoaderHelper.getClassLoaderLogName((ClassLoader)associatedClassLoader) + " was not associated to AppDomain " + appDomainId);
        }
    }

    public static synchronized void adjustContextClassLoader(int appDomainId) {
        Long associatedClassLoaderKey = appDomainToClassLoader.get(appDomainId);
        if (associatedClassLoaderKey == null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("trying to adjusting thread [" + Thread.currentThread().getName() + "] context class loader according to AppDomain " + appDomainId + " which has no associated existing class loader, setting default class loader [" + ClassLoaderHelper.getClassLoaderLogName((ClassLoader)PbsExecuter.class.getClassLoader()) + "]");
            }
            ClassLoaderHelper.setContextClassLoader((ClassLoader)PbsExecuter.class.getClassLoader(), (boolean)true);
            return;
        }
        ClassLoader associatedClassLoader = ClassLoaderCache.getCache().getClassLoader(associatedClassLoaderKey);
        if (associatedClassLoader == null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("trying to adjusting thread [" + Thread.currentThread().getName() + "] context class loader according to AppDomain " + appDomainId + " which has no associated existing class loader, setting default class loader [" + ClassLoaderHelper.getClassLoaderLogName((ClassLoader)PbsExecuter.class.getClassLoader()) + "]");
            }
            ClassLoaderHelper.setContextClassLoader((ClassLoader)PbsExecuter.class.getClassLoader(), (boolean)true);
            return;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("adjusting thread [" + Thread.currentThread().getName() + "] context class loader [" + ClassLoaderHelper.getClassLoaderLogName((ClassLoader)associatedClassLoader) + "] according to AppDomain " + appDomainId);
        }
        ClassLoaderHelper.setContextClassLoader((ClassLoader)associatedClassLoader, (boolean)true);
    }

    public static Integer getAssociatedAppDomainId(IDotnetProxyAssociated object) {
        Integer contextAppDomain = PbsExecuter.getContextAppDomainId();
        if (contextAppDomain == null && object.hasAssociatedAppDomain()) {
            int associatedAppDomain = object.getAppDomainId();
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("got associated AppDomain id [" + associatedAppDomain + "] for " + object + " using context class loader association");
            }
            return associatedAppDomain;
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("got associated AppDomain id [" + contextAppDomain + "] for " + object + " using context class loader association");
        }
        return contextAppDomain;
    }

    public static Integer getContextAppDomainId() {
        ClassLoader contextClassLoader = ClassLoaderHelper.getContextClassLoader();
        if (contextClassLoader == null) {
            return 1;
        }
        Long classLoaderKey = ClassLoaderCache.getCache().getClassLoaderKey(contextClassLoader);
        if (multiAssociatedClassLoader.contains(classLoaderKey)) {
            return null;
        }
        Integer appDomainId = classLoaderToAppDomain.get(classLoaderKey);
        if (appDomainId == null) {
            throw new IllegalStateException("No AppDomain is associated with the context class loader [" + ClassLoaderHelper.getClassLoaderLogName((ClassLoader)contextClassLoader) + "]");
        }
        return appDomainId;
    }

    public static byte[] executeCommand(byte[] command) {
        _auditor.logEnter();
        PbsOutputStream output = PbsStreamResource.getOutputStream();
        PbsInputStream input = PbsStreamResource.getInputStream((byte[])command);
        try {
            byte bundleCode = input.readByte();
            byte operationCode = input.readByte();
            long handleId = input.readLong();
            AbstractPbsExecutersBundle<?> bundle = PbsExecuter.getBundleByCode(bundleCode);
            output.writeShort((short)0);
            bundle.execute(operationCode, handleId, input, output);
        }
        catch (Throwable e) {
            _auditor.logError();
            PbsExceptionFormatter.writeException(output, e, (short)1, true);
        }
        PbsStreamResource.releasePbsStream((IThreadLocalResource)input);
        PbsStreamResource.releasePbsStream((IThreadLocalResource)output);
        byte[] result = output.getCompactBuffer();
        _auditor.logExit();
        return result;
    }

    private static AbstractPbsExecutersBundle<?> getBundleByCode(byte bundleCode) {
        switch (bundleCode) {
            case 0: {
                return ISpaceProxyBundle;
            }
            case 1: {
                return DataEventSessionBundle;
            }
            case 2: {
                return LeaseBundle;
            }
            case 3: {
                return TransactionBundle;
            }
            case 4: {
                return EventRegistrationBundle;
            }
            case 5: {
                return TransactionManagerBundle;
            }
            case 6: {
                return PreparedTemplateBundle;
            }
            case 7: {
                return GSIteratorBundle;
            }
            case 8: {
                return IRemoteJSpaceAdminBundle;
            }
            case 9: {
                return CallbackCheckBundle;
            }
            case 10: {
                return IFilterEntryBundle;
            }
            case 11: {
                return AdminBundle;
            }
            case 12: {
                return SpaceIteratorBundle;
            }
            case 125: {
                return StringBundle;
            }
            case 126: {
                return StaticBundle;
            }
            case 127: {
                return TestBundle;
            }
        }
        throw new PBSInternalSpaceException("Unknown Delegates bundle code " + bundleCode);
    }

    static {
        ISpaceProxyBundle = new ISpaceProxyBundle(0);
        DataEventSessionBundle = new DataEventSessionBundle(1);
        LeaseBundle = new LeaseBundle(2);
        TransactionBundle = new TransactionBundle(3);
        EventRegistrationBundle = new EventRegistrationBundle(4);
        TransactionManagerBundle = new TranscationManagerBundle(5);
        PreparedTemplateBundle = new PreparedTemplateBundle(6);
        GSIteratorBundle = new GSIteratorBundle(7);
        SpaceIteratorBundle = new SpaceIteratorBundle(12);
        IRemoteJSpaceAdminBundle = new IRemoteJSpaceAdminBundle(8);
        CallbackCheckBundle = new CallbackCheckBundle(9);
        IFilterEntryBundle = new IFilterEntryBundle(10);
        AdminBundle = new AdminBundle(11);
        StringBundle = new StringBundle(125);
        StaticBundle = new StaticBundle(126);
        TestBundle = new TestBundle(127);
        classLoaderToAppDomain = new CopyOnUpdateMap();
        appDomainToClassLoader = new CopyOnUpdateMap();
        multiAssociatedClassLoader = new CopyOnUpdateSet();
        listener = new IClassLoaderCacheStateListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onClassLoaderRemoved(Long classLoaderKey, boolean explicit) {
                Class<PbsExecuter> clazz = PbsExecuter.class;
                synchronized (PbsExecuter.class) {
                    Integer appDomainKey = (Integer)classLoaderToAppDomain.remove(classLoaderKey);
                    boolean hasMultiAssoc = multiAssociatedClassLoader.remove(classLoaderKey);
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.fine("removing associated AppDomain " + appDomainKey + " do to self cleaning of context class loader");
                    }
                    if (appDomainKey != null) {
                        appDomainToClassLoader.remove(appDomainKey);
                    }
                    if (!hasMultiAssoc) {
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        return;
                    }
                    ArrayList appDomainToRemove = new ArrayList();
                    for (Map.Entry entry : appDomainToClassLoader.entrySet()) {
                        if (!((Long)entry.getValue()).equals(classLoaderKey)) continue;
                        appDomainToRemove.add(entry.getKey());
                    }
                    for (Integer appDomainId : appDomainToRemove) {
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.fine("removing associated AppDomain " + appDomainId + " do to self cleaning of context class loader");
                        }
                        appDomainToClassLoader.remove(appDomainId);
                    }
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return;
                }
            }
        };
        GSLogConfigLoader.getLoader();
        _logger = Logger.getLogger("com.gigaspaces.bridge.pbsexecuter");
        _auditor = new PbsAuditor("PbsExecutor.ExecuteCommand");
        ClassLoaderCache.getCache().registerCacheStateListener(listener);
    }
}

