/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.serialization.pbs.executers.admin;

import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.serialization.pbs.PbsEntryFormatter;
import com.gigaspaces.serialization.pbs.PbsExceptionFormatter;
import com.gigaspaces.serialization.pbs.PbsInputStream;
import com.gigaspaces.serialization.pbs.PbsOutputStream;
import com.gigaspaces.serialization.pbs.commands.admincallbacks.GenericAdminInvocationHandler;
import com.gigaspaces.serialization.pbs.executers.AbstractPbsExecuter;
import com.gigaspaces.serialization.pbs.executers.AbstractPbsExecutersBundle;
import com.gigaspaces.serialization.pbs.executers.PbsExecuter;
import com.gigaspaces.serialization.pbs.executers.admin.CreateAdmin;
import com.gigaspaces.serialization.pbs.executers.admin.GenericAdminCommand;
import com.gigaspaces.serialization.pbs.executers.admin.GenericConstructorAdminCommand;
import com.j_spaces.core.exception.internal.PBSInternalSpaceException;
import com.j_spaces.kernel.ClassLoaderHelper;
import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public class AdminBundle
extends AbstractPbsExecutersBundle<Object> {
    private static final String PRIMITIVE_BOOLEAN_CLASS_NAME = "boolean";
    private static final String PRIMITIVE_BYTE_CLASS_NAME = "byte";
    private static final String PRIMITIVE_CHAR_CLASS_NAME = "char";
    private static final String PRIMITIVE_SHORT_CLASS_NAME = "short";
    private static final String PRIMITIVE_INT_CLASS_NAME = "int";
    private static final String PRIMITIVE_LONG_CLASS_NAME = "long";
    private static final String PRIMITIVE_FLOAT_CLASS_NAME = "float";
    private static final String PRIMITIVE_DOUBLE_CLASS_NAME = "double";
    private static final Map<String, Class<?>> javaPrimitiveClasses = AdminBundle.buildPrimitiveClasses();
    private static final byte NATIVE_ARGUMENT = 0;
    private static final byte PROXY_ARGUMENT = 1;
    private static final byte CALLBACK_ARGUMENT = 2;
    private static final byte SPECIAL_ARGUMENT = 3;

    public AdminBundle(byte bundleCode) {
        super(bundleCode, "Admin");
    }

    @Override
    protected AbstractPbsExecuter[] initExecuters() {
        AbstractPbsExecuter[] executers = new AbstractPbsExecuter[4];
        executers[1] = new CreateAdmin(this);
        executers[2] = new GenericAdminCommand(this);
        executers[3] = new GenericConstructorAdminCommand(this);
        return executers;
    }

    private static Map<String, Class<?>> buildPrimitiveClasses() {
        HashMap result = new HashMap();
        result.put(PRIMITIVE_BOOLEAN_CLASS_NAME, Boolean.TYPE);
        result.put(PRIMITIVE_BYTE_CLASS_NAME, Byte.TYPE);
        result.put(PRIMITIVE_CHAR_CLASS_NAME, Character.TYPE);
        result.put(PRIMITIVE_SHORT_CLASS_NAME, Short.TYPE);
        result.put(PRIMITIVE_INT_CLASS_NAME, Integer.TYPE);
        result.put(PRIMITIVE_LONG_CLASS_NAME, Long.TYPE);
        result.put(PRIMITIVE_FLOAT_CLASS_NAME, Float.TYPE);
        result.put(PRIMITIVE_DOUBLE_CLASS_NAME, Double.TYPE);
        return result;
    }

    static Class<?>[] createClassesFromNames(String[] paramTypes) throws ClassNotFoundException {
        if (paramTypes == null) {
            return null;
        }
        Class[] result = new Class[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            result[i] = javaPrimitiveClasses.containsKey(paramTypes[i]) ? javaPrimitiveClasses.get(paramTypes[i]) : Class.forName(paramTypes[i], true, Thread.currentThread().getContextClassLoader());
        }
        return result;
    }

    static Object[] readArguments(PbsInputStream input, Class<?>[] paramTypes) {
        int length = input.readInt();
        if (length == -1) {
            return null;
        }
        Object[] result = new Object[length];
        block6: for (int i = 0; i < length; ++i) {
            byte argumentType = input.readByte();
            switch (argumentType) {
                case 0: {
                    result[i] = AdminBundle.readSerializedArgument(input, paramTypes[i]);
                    continue block6;
                }
                case 1: {
                    result[i] = PbsExecuter.AdminBundle.getInstance(input.readLong());
                    continue block6;
                }
                case 2: {
                    result[i] = AdminBundle.createCallbackProxy(input.readLong(), input.readInt(), paramTypes[i]);
                    continue block6;
                }
                case 3: {
                    result[i] = AdminBundle.readSpecialArgument(input, paramTypes[i]);
                    continue block6;
                }
                default: {
                    throw new PBSInternalSpaceException("Unknown argument type [" + argumentType + "]");
                }
            }
        }
        return result;
    }

    private static Object readSpecialArgument(PbsInputStream input, Class clazz) {
        String valueString = input.readString();
        if (clazz.isEnum()) {
            return Enum.valueOf(clazz, valueString);
        }
        throw new IllegalArgumentException("Unhandled special argument " + clazz.getName());
    }

    private static Object readSerializedArgument(PbsInputStream input, Class<?> clazz) {
        Object result = PbsEntryFormatter.readFieldValue((PbsInputStream)input);
        if (clazz.equals(TimeUnit.class)) {
            return TimeUnit.MILLISECONDS;
        }
        if (clazz.equals(File.class)) {
            return new File((String)result);
        }
        return result;
    }

    private static Object createCallbackProxy(long handleId, int appDomainId, Class<?> type) {
        return Proxy.newProxyInstance(ClassLoaderHelper.getContextClassLoader(), new Class[]{type}, (InvocationHandler)new GenericAdminInvocationHandler(handleId, appDomainId));
    }

    public static void writeGenericObject(PbsOutputStream output, Object obj, boolean returnNativeMap, boolean forceStringResult) throws IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (obj == null) {
            output.writeBoolean(false);
            return;
        }
        output.writeBoolean(true);
        if (!returnNativeMap && forceStringResult) {
            obj = obj.toString();
        }
        AdminBundle.writeAcordingToType(output, obj, returnNativeMap, forceStringResult);
    }

    private static void writeAcordingToType(PbsOutputStream output, Object obj, boolean returnNativeMap, boolean forceStringResult) throws IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (obj instanceof String || obj instanceof String[] || obj instanceof Integer || obj instanceof Integer[] || obj instanceof Boolean || obj instanceof Boolean[] || obj instanceof Long || obj instanceof Long[] || obj instanceof Double || obj instanceof Double[] || obj instanceof Float || obj instanceof Float[] || obj instanceof Short || obj instanceof Short[] || obj instanceof Byte || obj instanceof Byte[] || obj instanceof Character || obj instanceof Character[] || obj instanceof UUID || obj instanceof UUID[]) {
            AdminBundle.writeNativeValue(output, obj);
            return;
        }
        if (obj.getClass().isArray() || obj instanceof List) {
            AdminBundle.writeProxyList(output, obj);
            return;
        }
        if (obj instanceof Map) {
            AdminBundle.writeMap(output, obj, returnNativeMap, forceStringResult);
            return;
        }
        if (obj.getClass().isEnum()) {
            AdminBundle.writeEnum(output, obj);
            return;
        }
        if (obj instanceof Throwable) {
            AdminBundle.writeException(output, (Throwable)obj);
            return;
        }
        Class<?> clazz = obj.getClass();
        String className = clazz.getName();
        Class<?>[] interfaces = clazz.getInterfaces();
        if (Map.Entry.class.isAssignableFrom(clazz)) {
            output.writeByte(InteropType.CUSTOM.getCode());
            output.writeString(Map.Entry.class.getName());
            Map.Entry entry = (Map.Entry)obj;
            Object key = entry.getKey();
            Object value = entry.getValue();
            AdminBundle.writeGenericObject(output, key, false, false);
            AdminBundle.writeGenericObject(output, value, false, false);
            return;
        }
        if (className.equals("org.openspaces.core.cluster.ClusterInfo")) {
            output.writeByte(InteropType.CUSTOM.getCode());
            output.writeString(className);
            output.writeString((String)clazz.getMethod("getSchema", new Class[0]).invoke(obj, new Object[0]));
            AdminBundle.writeIntegerProperty(output, obj, clazz, "getInstanceId");
            AdminBundle.writeIntegerProperty(output, obj, clazz, "getBackupId");
            AdminBundle.writeIntegerProperty(output, obj, clazz, "getNumberOfInstances");
            AdminBundle.writeIntegerProperty(output, obj, clazz, "getNumberOfBackups");
            return;
        }
        for (Class<?> interfaceClass : interfaces) {
            if (!interfaceClass.getName().equals("org.openspaces.core.GigaSpace")) continue;
            output.writeByte(InteropType.CUSTOM.getCode());
            ISpaceProxy result = (ISpaceProxy)clazz.getMethod("getSpace", new Class[0]).invoke(obj, new Object[0]);
            output.writeString(interfaceClass.getName());
            PbsExecuter.ISpaceProxyBundle.addAndSerializeProxyProperties(output, result, null);
            return;
        }
        AdminBundle.writeProxy(output, obj);
    }

    private static void writeIntegerProperty(PbsOutputStream output, Object obj, Class<? extends Object> clazz, String propertyName) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Integer value = (Integer)clazz.getMethod(propertyName, new Class[0]).invoke(obj, new Object[0]);
        if (value != null) {
            output.writeBoolean(true);
            output.writeInt(value.intValue());
        } else {
            output.writeBoolean(false);
        }
    }

    private static void writeNativeValue(PbsOutputStream output, Object obj) {
        output.writeByte(InteropType.NATIVE.getCode());
        PbsEntryFormatter.writeFieldValue((PbsOutputStream)output, (Object)obj);
    }

    private static void writeEnum(PbsOutputStream output, Object obj) {
        output.writeByte(InteropType.ENUM.getCode());
        output.writeString(obj.getClass().getName());
        output.writeString(obj.toString());
    }

    private static void writeException(PbsOutputStream output, Throwable t) {
        output.writeByte(InteropType.EXCEPTION.getCode());
        PbsExceptionFormatter.writeException(output, t, (short)1, false);
    }

    private static void writeProxy(PbsOutputStream output, Object obj) {
        output.writeByte(InteropType.SINGLE_PROXY.getCode());
        PbsExecuter.AdminBundle.addInstance(obj, output);
    }

    private static void writeMap(PbsOutputStream output, Object obj, boolean returnNativeMap, boolean forceStringResult) {
        output.writeByte(InteropType.MAP.getCode());
        if (returnNativeMap) {
            Map map = (Map)obj;
            output.writeInt(map.size());
            for (Map.Entry entry : map.entrySet()) {
                AdminBundle.writeNativeOnly(output, entry.getKey(), forceStringResult);
                AdminBundle.writeNativeOnly(output, entry.getValue(), forceStringResult);
            }
        } else {
            PbsExecuter.AdminBundle.addInstance(obj, output);
        }
    }

    private static void writeNativeOnly(PbsOutputStream output, Object obj, boolean forceStringResult) {
        if (obj == null) {
            output.writeBoolean(false);
            return;
        }
        output.writeBoolean(true);
        if (!(!forceStringResult && (obj instanceof String || obj instanceof String[] || obj instanceof Integer || obj instanceof Integer[] || obj instanceof Boolean || obj instanceof Boolean[] || obj instanceof Long || obj instanceof Long[]))) {
            obj = obj.toString();
        }
        PbsEntryFormatter.writeFieldValue((PbsOutputStream)output, (Object)obj);
    }

    private static void writeProxyList(PbsOutputStream output, Object obj) {
        output.writeByte(InteropType.LIST_PROXY.getCode());
        boolean interopArray = obj.getClass().isArray();
        if (interopArray) {
            int length = Array.getLength(obj);
            output.writeInt(length);
            for (int i = 0; i < length; ++i) {
                PbsExecuter.AdminBundle.addInstance(Array.get(obj, i), output);
            }
        } else {
            List list = (List)obj;
            int length = list.size();
            output.writeInt(length);
            for (Object item : list) {
                PbsExecuter.AdminBundle.addInstance(item, output);
            }
        }
    }

    private static enum InteropType {
        NATIVE(0),
        ENUM(1),
        CUSTOM(2),
        SINGLE_PROXY(3),
        LIST_PROXY(4),
        MAP(5),
        EXCEPTION(6);

        private final byte _code;

        private InteropType(byte code) {
            this._code = code;
        }

        public byte getCode() {
            return this._code;
        }
    }
}

