/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.serialization.pbs.executers.admin;

import com.gigaspaces.serialization.pbs.PbsInputStream;
import com.gigaspaces.serialization.pbs.PbsOutputStream;
import com.gigaspaces.serialization.pbs.executers.AbstractPbsExecuter;
import com.gigaspaces.serialization.pbs.executers.AbstractPbsExecutersBundle;
import com.gigaspaces.serialization.pbs.executers.PbsExecuter;
import java.lang.reflect.InvocationTargetException;

public class CreateAdmin
extends AbstractPbsExecuter {
    public CreateAdmin(AbstractPbsExecutersBundle<?> bundle) {
        super(bundle, "CreateAdmin");
    }

    @Override
    public void execute(PbsInputStream input, PbsOutputStream output, long handleId) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, SecurityException, InvocationTargetException, NoSuchMethodException {
        String[] groups = input.readStringArray();
        String[] locators = input.readStringArray();
        String userName = input.readString();
        String password = input.readString();
        boolean discoverUnmanaged = input.readBoolean();
        Class<?> adminFactoryClass = Class.forName("org.openspaces.admin.AdminFactory", true, Thread.currentThread().getContextClassLoader());
        Object adminFactory = adminFactoryClass.newInstance();
        if (groups != null) {
            for (String group : groups) {
                adminFactoryClass.getMethod("addGroup", String.class).invoke(adminFactory, group);
            }
        }
        if (locators != null) {
            for (String locator : locators) {
                adminFactoryClass.getMethod("addLocator", String.class).invoke(adminFactory, locator);
            }
        }
        if (userName != null) {
            adminFactoryClass.getMethod("userDetails", String.class, String.class).invoke(adminFactory, userName, password);
        }
        if (discoverUnmanaged) {
            adminFactoryClass.getMethod("discoverUnmanagedSpaces", new Class[0]).invoke(adminFactory, new Object[0]);
        }
        Object admin = adminFactoryClass.getMethod("createAdmin", new Class[0]).invoke(adminFactory, new Object[0]);
        PbsExecuter.AdminBundle.addInstance(admin, output);
    }
}

