/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.serialization.pbs.executers.dataeventsession;

import com.gigaspaces.events.AbstractDataEventSession;
import com.gigaspaces.events.NotifyActionType;
import com.gigaspaces.events.NotifyInfo;
import com.gigaspaces.events.batching.BatchRemoteEvent;
import com.gigaspaces.events.batching.BatchRemoteEventListener;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.gigaspaces.serialization.pbs.PbsAuditor;
import com.gigaspaces.serialization.pbs.PbsEntryFormatter;
import com.gigaspaces.serialization.pbs.PbsInputStream;
import com.gigaspaces.serialization.pbs.PbsOutputStream;
import com.gigaspaces.serialization.pbs.commands.DispatcherObjectProxy;
import com.gigaspaces.serialization.pbs.commands.eventscallbacks.Notify;
import com.gigaspaces.serialization.pbs.executers.AbstractPbsExecuter;
import com.gigaspaces.serialization.pbs.executers.AbstractPbsExecutersBundle;
import com.gigaspaces.serialization.pbs.executers.PbsExecuter;
import com.j_spaces.core.client.EntryArrivedRemoteEvent;
import java.rmi.RemoteException;
import java.util.logging.Level;
import net.jini.core.event.EventRegistration;
import net.jini.core.event.RemoteEvent;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.event.UnknownEventException;
import net.jini.core.lease.Lease;
import net.jini.core.transaction.TransactionException;

public class AddListener
extends AbstractPbsExecuter {
    public AddListener(AbstractPbsExecutersBundle<?> bundle) {
        super(bundle, "AddListener");
    }

    @Override
    public void execute(PbsInputStream input, PbsOutputStream output, long handleId) throws RemoteException, TransactionException {
        AbstractDataEventSession eventSession = (AbstractDataEventSession)PbsExecuter.DataEventSessionBundle.getInstance(handleId);
        long callbackHandleId = input.readLong();
        int contextAppDomainId = input.readInt();
        ITemplatePacket template = PbsEntryFormatter.readPbsTemplate((PbsInputStream)input, (ISpaceProxy)((ISpaceProxy)eventSession.getSpace()));
        long leaseDuration = input.readLong();
        int notificationType = input.readInt();
        int modifiers = input.readInt();
        boolean isBatch = input.readBoolean();
        boolean isReturnOnlyUid = input.readBoolean();
        DispatcherObjectProxy listener = !isBatch ? new DispatcherCallbackRemoteEventListener(callbackHandleId, contextAppDomainId, isReturnOnlyUid) : new DispatcherCallbackBatchRemoteEventListener(callbackHandleId, contextAppDomainId, isReturnOnlyUid);
        NotifyInfo notifyInfo = eventSession.createNotifyInfo((RemoteEventListener)listener, NotifyActionType.fromModifier((int)notificationType)).setReturnOnlyUids(isReturnOnlyUid);
        notifyInfo.setModifiers(notifyInfo.getModifiers() + modifiers);
        EventRegistration eventRegistration = eventSession.addListener((Object)template, leaseDuration, notifyInfo);
        PbsExecuter.EventRegistrationBundle.addInstance(eventRegistration, output);
        output.writeLong(eventRegistration.getID());
        output.writeLong(eventRegistration.getSequenceNumber());
        Lease lease = eventRegistration.getLease();
        if (lease == null) {
            output.writeBoolean(false);
        } else {
            output.writeBoolean(true);
            PbsExecuter.LeaseBundle.addAndSerializeLease(output, lease);
        }
    }

    private static class DispatcherCallbackBatchRemoteEventListener
    extends DispatcherObjectProxy
    implements BatchRemoteEventListener {
        private static final PbsAuditor _auditor = new PbsAuditor("BatchEventListener.Notify");
        private static final PbsAuditor _auditorBatch = new PbsAuditor("BatchEventListener.NotifyBatch");
        private final boolean _isReturnOnlyUid;

        public DispatcherCallbackBatchRemoteEventListener(long returnHandleId, int contextAppDomainId, boolean isReturnOnlyUid) {
            super((byte)3, returnHandleId, contextAppDomainId);
            this._isReturnOnlyUid = isReturnOnlyUid;
        }

        public void notify(RemoteEvent remoteEvent) throws UnknownEventException, RemoteException {
            _auditor.logEnter();
            try {
                boolean callbackActive = Notify.execute((DispatcherObjectProxy)this, (EntryArrivedRemoteEvent)remoteEvent, this._isReturnOnlyUid);
                if (!callbackActive && _logger.isLoggable(Level.FINEST)) {
                    _logger.log(Level.FINEST, "Callback of DataEventSession notification is inactive, handle id: " + this.getHandleId());
                }
            }
            catch (Exception e) {
                _auditor.logError();
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.log(Level.FINEST, "Callback of RemoteEventListener failed, handle id: " + this.getHandleId() + " - " + e);
                }
                throw new RemoteException("Error while dispatching event", e);
            }
            finally {
                _auditor.logExit();
            }
        }

        public void notifyBatch(BatchRemoteEvent remoteEvents) throws UnknownEventException, RemoteException {
            _auditorBatch.logEnter();
            try {
                boolean callbackActive = Notify.execute((DispatcherObjectProxy)this, remoteEvents.getEvents(), this._isReturnOnlyUid);
                if (!callbackActive && _logger.isLoggable(Level.FINEST)) {
                    _logger.log(Level.FINEST, "Callback of DataEventSession notification is inactive, handle id: " + this.getHandleId());
                }
            }
            catch (Exception e) {
                _auditorBatch.logError();
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.log(Level.FINEST, "Callback of RemoteEventListener failed, handle id: " + this.getHandleId() + " - " + e);
                }
                throw new RemoteException("Error while dispatching event", e);
            }
            finally {
                _auditorBatch.logExit();
            }
        }
    }

    private static class DispatcherCallbackRemoteEventListener
    extends DispatcherObjectProxy
    implements RemoteEventListener {
        private static final PbsAuditor _auditor = new PbsAuditor("EventListener.Notify");
        private final boolean _isReturnOnlyUid;

        public DispatcherCallbackRemoteEventListener(long returnHandleId, int contextAppDomainId, boolean isReturnOnlyUid) {
            super((byte)3, returnHandleId, contextAppDomainId);
            this._isReturnOnlyUid = isReturnOnlyUid;
        }

        public void notify(RemoteEvent remoteEvent) throws UnknownEventException, RemoteException {
            _auditor.logEnter();
            try {
                boolean callbackActive = Notify.execute((DispatcherObjectProxy)this, (EntryArrivedRemoteEvent)remoteEvent, this._isReturnOnlyUid);
                if (!callbackActive && _logger.isLoggable(Level.FINEST)) {
                    _logger.log(Level.FINEST, "Callback of DataEventSession notification is inactive, handle id: " + this.getHandleId());
                }
            }
            catch (Exception e) {
                _auditor.logError();
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.log(Level.FINEST, "Callback of RemoteEventListener failed, handle id: " + this.getHandleId() + " - " + e);
                }
                throw new RemoteException("Error while dispatching event", e);
            }
            finally {
                _auditor.logExit();
            }
        }
    }
}

