/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.serialization.pbs.executers.dataeventsession;

import com.gigaspaces.events.DataEventSession;
import com.gigaspaces.events.DataEventSessionFactory;
import com.gigaspaces.events.EventSessionConfig;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.serialization.pbs.PbsInputStream;
import com.gigaspaces.serialization.pbs.PbsOutputStream;
import com.gigaspaces.serialization.pbs.commands.DispatcherObjectProxy;
import com.gigaspaces.serialization.pbs.commands.leaselistenercallbacks.Notify;
import com.gigaspaces.serialization.pbs.executers.AbstractPbsExecuter;
import com.gigaspaces.serialization.pbs.executers.AbstractPbsExecutersBundle;
import com.gigaspaces.serialization.pbs.executers.PbsExecuter;
import com.gigaspaces.serialization.pbs.executers.ispaceproxy.SpaceProxyWrapper;
import com.j_spaces.core.IJSpace;
import java.rmi.RemoteException;
import java.util.logging.Level;
import net.jini.lease.LeaseListener;
import net.jini.lease.LeaseRenewalEvent;

public class Construct
extends AbstractPbsExecuter {
    public Construct(AbstractPbsExecutersBundle<?> bundle) {
        super(bundle, "Construct");
    }

    @Override
    public void execute(PbsInputStream input, PbsOutputStream output, long handleId) throws RemoteException {
        ISpaceProxy spaceProxy = ((SpaceProxyWrapper)PbsExecuter.ISpaceProxyBundle.readInstance(input)).getProxy();
        EventSessionConfig config = Construct.readEventSessionConfig(input);
        DataEventSession eventSession = DataEventSessionFactory.create((IJSpace)spaceProxy, (EventSessionConfig)config);
        PbsExecuter.DataEventSessionBundle.addInstance(eventSession, output);
    }

    public static EventSessionConfig readEventSessionConfig(PbsInputStream input) {
        Boolean triggerNotifyTemplate;
        boolean batch;
        EventSessionConfig config = new EventSessionConfig();
        boolean autoRenew = input.readBoolean();
        if (autoRenew) {
            long autoRenewDuration = input.readLong();
            long autoRenewExpiration = input.readLong();
            long autoRenewRTT = input.readLong();
            long renewalCallbackHandleId = input.readLong();
            int contextAppDomainId = input.readInt();
            DispatcherCallbackLeaseListener listener = new DispatcherCallbackLeaseListener(renewalCallbackHandleId, contextAppDomainId);
            config.setAutoRenew(true, (LeaseListener)listener, autoRenewExpiration, autoRenewDuration, autoRenewRTT);
        }
        if (batch = input.readBoolean()) {
            int batchSize = input.readInt();
            long batchTime = input.readLong();
            int batchPendingThreshold = input.readInt();
            config.setBatch(batchSize, batchTime, batchPendingThreshold);
        }
        String comTypeName = input.readString();
        boolean fifo = input.readBoolean();
        config.setFifo(fifo);
        Boolean replicateNotifyTemplate = input.readNullableBoolean();
        if (replicateNotifyTemplate != null) {
            config.setReplicateNotifyTemplate(replicateNotifyTemplate.booleanValue());
        }
        if ((triggerNotifyTemplate = input.readNullableBoolean()) != null) {
            config.setTriggerNotifyTemplate(triggerNotifyTemplate.booleanValue());
        }
        boolean guaranteedNotifications = input.readBoolean();
        config.setGuaranteedNotifications(guaranteedNotifications);
        boolean durableNotifications = input.readBoolean();
        config.setDurableNotifications(durableNotifications);
        return config;
    }

    private static class DispatcherCallbackLeaseListener
    extends DispatcherObjectProxy
    implements LeaseListener {
        public DispatcherCallbackLeaseListener(long handleId, int contextAppDomainId) {
            super((byte)5, handleId, contextAppDomainId);
        }

        public void notify(LeaseRenewalEvent renewlEventArgs) {
            block3: {
                try {
                    boolean callbackActive = Notify.execute(this, renewlEventArgs);
                    if (!callbackActive && _logger.isLoggable(Level.FINEST)) {
                        _logger.log(Level.FINEST, "Callback of LeaseRenewalFailedEvent notification is inactive, handle id: " + this.getHandleId());
                    }
                }
                catch (Exception e) {
                    if (!_logger.isLoggable(Level.FINEST)) break block3;
                    _logger.log(Level.FINEST, "Callback of LeaseRenewalFailedEvent failed, handle id: " + this.getHandleId() + " - " + e);
                }
            }
        }
    }
}

