/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.serialization.pbs.executers.gsiterator;

import com.gigaspaces.client.iterator.GSIteratorConfig;
import com.gigaspaces.client.iterator.IteratorScope;
import com.gigaspaces.events.EventSessionConfig;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.gigaspaces.serialization.pbs.PbsEntryFormatter;
import com.gigaspaces.serialization.pbs.PbsInputStream;
import com.gigaspaces.serialization.pbs.PbsOutputStream;
import com.gigaspaces.serialization.pbs.executers.AbstractPbsExecuter;
import com.gigaspaces.serialization.pbs.executers.AbstractPbsExecutersBundle;
import com.gigaspaces.serialization.pbs.executers.PbsExecuter;
import com.gigaspaces.serialization.pbs.executers.ispaceproxy.SpaceProxyWrapper;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.client.GSIterator;
import java.rmi.RemoteException;
import java.util.ArrayList;
import net.jini.core.entry.UnusableEntryException;

public class Construct
extends AbstractPbsExecuter {
    public Construct(AbstractPbsExecutersBundle<?> bundle) {
        super(bundle, "Construct");
    }

    @Override
    public void execute(PbsInputStream input, PbsOutputStream output, long handleId) throws RemoteException, UnusableEntryException {
        ISpaceProxy spaceProxy = ((SpaceProxyWrapper)PbsExecuter.ISpaceProxyBundle.readInstance(input)).getProxy();
        int templatesLength = input.readInt();
        ArrayList<ITemplatePacket> templates = templatesLength == -1 ? null : new ArrayList<ITemplatePacket>(templatesLength);
        for (int i = 0; i < templatesLength; ++i) {
            templates.add(PbsEntryFormatter.readPbsTemplate((PbsInputStream)input, (ISpaceProxy)spaceProxy));
        }
        GSIteratorConfig config = Construct.readGSIteratorConfig(input);
        long previousHandleId = input.readLong();
        GSIterator gsIterator = new GSIterator((IJSpace)spaceProxy, templates, config);
        if (previousHandleId != -1L) {
            GSIterator previous = PbsExecuter.GSIteratorBundle.addInstance(previousHandleId, gsIterator);
            if (previous != null) {
                previous.cancel();
            }
        } else {
            PbsExecuter.GSIteratorBundle.addInstance(gsIterator, output);
        }
    }

    private static GSIteratorConfig readGSIteratorConfig(PbsInputStream input) {
        GSIteratorConfig config = new GSIteratorConfig();
        config.setBufferSize(input.readInt());
        int iteratorScopeCode = input.readInt();
        config.setIteratorScope(Construct.iteratorScopefromCode(iteratorScopeCode));
        config.setLeaseDuration(input.readLong());
        EventSessionConfig eventConfig = com.gigaspaces.serialization.pbs.executers.dataeventsession.Construct.readEventSessionConfig(input);
        config.setEventSessionConfig(eventConfig);
        return config;
    }

    private static IteratorScope iteratorScopefromCode(int iteratorScopeCode) {
        switch (iteratorScopeCode) {
            case 1: {
                return IteratorScope.CURRENT;
            }
            case 2: {
                return IteratorScope.FUTURE;
            }
            case 3: {
                return IteratorScope.CURRENT_AND_FUTURE;
            }
        }
        return null;
    }
}

