/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.serialization.pbs.executers.internaltest;

import com.gigaspaces.serialization.pbs.PbsInputStream;
import com.gigaspaces.serialization.pbs.PbsOutputStream;
import com.gigaspaces.serialization.pbs.executers.AbstractPbsExecuter;
import com.gigaspaces.serialization.pbs.executers.AbstractPbsExecutersBundle;
import java.util.Map;

public class DumpAllThreadsStacksCommand
extends AbstractPbsExecuter {
    public DumpAllThreadsStacksCommand(AbstractPbsExecutersBundle<?> bundle) {
        super(bundle, "DumpAllThreadsStacksCommand");
    }

    @Override
    public void execute(PbsInputStream input, PbsOutputStream output, long handleId) {
        String dump = DumpAllThreadsStacksCommand.dumpAllThreadStacks();
        output.writeString(dump);
    }

    private static String dumpAllThreadStacks() {
        StringBuilder sb = new StringBuilder("*************** Thread dump ***************\n");
        try {
            Map<Thread, StackTraceElement[]> stacks = Thread.getAllStackTraces();
            for (Map.Entry<Thread, StackTraceElement[]> stack : stacks.entrySet()) {
                Thread thread = stack.getKey();
                sb.append("*** Thread " + thread.getName() + " is " + (Object)((Object)thread.getState()) + "\n");
                for (StackTraceElement elem : stack.getValue()) {
                    sb.append('\t' + elem.toString() + "\n");
                }
                sb.append("------------------------------------------\n");
            }
        }
        catch (NoSuchMethodError nsme) {
            sb.append("No stack is available for jdk1.4, listing threads in thread group: ");
            ThreadGroup group = Thread.currentThread().getThreadGroup();
            group.list();
        }
        return sb.toString();
    }
}

