/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.serialization.pbs.executers.iremotejspaceadmin;

import com.gigaspaces.cluster.loadbalance.LoadBalancingPolicy;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.serialization.pbs.PbsInputStream;
import com.gigaspaces.serialization.pbs.PbsOutputStream;
import com.gigaspaces.serialization.pbs.executers.AbstractPbsExecuter;
import com.gigaspaces.serialization.pbs.executers.AbstractPbsExecutersBundle;
import com.gigaspaces.serialization.pbs.executers.PbsExecuter;
import com.gigaspaces.serialization.pbs.executers.ispaceproxy.SpaceProxyWrapper;
import com.j_spaces.core.NoSuchNameException;
import com.j_spaces.core.admin.IInternalRemoteJSpaceAdmin;
import com.j_spaces.core.client.SpaceURL;
import com.j_spaces.core.cluster.ClusterPolicy;
import com.j_spaces.core.cluster.FailOverPolicy;
import com.j_spaces.core.cluster.ReplicationPolicy;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Construct
extends AbstractPbsExecuter {
    public Construct(AbstractPbsExecutersBundle<?> bundle) {
        super(bundle, "Construct");
    }

    @Override
    public void execute(PbsInputStream input, PbsOutputStream output, long handleId) throws RemoteException, NoSuchNameException {
        ISpaceProxy space = ((SpaceProxyWrapper)PbsExecuter.ISpaceProxyBundle.readInstance(input)).getProxy();
        IInternalRemoteJSpaceAdmin admin = (IInternalRemoteJSpaceAdmin)space.getAdmin();
        PbsExecuter.IRemoteJSpaceAdminBundle.addInstance(admin, output);
        if (space.isClustered()) {
            HashMap<String, SpaceURL> clusterMembers = new HashMap<String, SpaceURL>();
            ClusterPolicy clusterPolicy = admin.getClusterPolicy();
            ReplicationPolicy replicationPolicy = clusterPolicy.m_ReplicationPolicy;
            FailOverPolicy failoverPolicy = clusterPolicy.m_FailOverPolicy;
            LoadBalancingPolicy loadBalancingPolicy = clusterPolicy.m_LoadBalancingPolicy;
            if (replicationPolicy != null) {
                this.appendToMap(clusterMembers, replicationPolicy.m_ReplicationGroupMembersNames, replicationPolicy.m_ReplicationGroupMembersURLs);
            }
            if (failoverPolicy != null) {
                this.appendToMap(clusterMembers, failoverPolicy.failOverGroupMembersNames, failoverPolicy.failOverGroupMembersURLs);
            }
            if (loadBalancingPolicy != null) {
                this.appendToMap(clusterMembers, loadBalancingPolicy.loadBalanceGroupMembersNames, loadBalancingPolicy.loadBalanceGroupMembersURLs);
            }
            output.writeInt(clusterMembers.size());
            for (Map.Entry<String, SpaceURL> entry : clusterMembers.entrySet()) {
                output.writeString(entry.getKey());
                output.writeString(entry.getValue().getURL());
            }
        } else {
            output.writeInt(1);
            output.writeString(space.getContainerName() + ":" + space.getName());
            String finderUrl = space.getFinderURL() == null ? null : space.getFinderURL().getURL();
            output.writeString(finderUrl);
        }
    }

    private void appendToMap(HashMap<String, SpaceURL> map, List<String> names, List<SpaceURL> urls) {
        for (int i = 0; i < names.size(); ++i) {
            if (map.containsKey(names.get(i))) continue;
            map.put(names.get(i), urls.get(i));
        }
    }
}

