/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.serialization.pbs.executers.iremotejspaceadmin;

import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.gigaspaces.serialization.pbs.PbsEntryFormatter;
import com.gigaspaces.serialization.pbs.PbsExceptionFormatter;
import com.gigaspaces.serialization.pbs.PbsInputStream;
import com.gigaspaces.serialization.pbs.PbsOutputStream;
import com.gigaspaces.serialization.pbs.executers.AbstractPbsExecuter;
import com.gigaspaces.serialization.pbs.executers.AbstractPbsExecutersBundle;
import com.gigaspaces.serialization.pbs.executers.PbsExecuter;
import com.gigaspaces.serialization.pbs.executers.ispaceproxy.SpaceProxyWrapper;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.SpaceCopyStatus;
import com.j_spaces.core.admin.IRemoteJSpaceAdmin;
import com.j_spaces.core.client.SpaceURL;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.Map;

public class SpaceCopy
extends AbstractPbsExecuter {
    public SpaceCopy(AbstractPbsExecutersBundle<?> bundle) {
        super(bundle, "SpaceCopy");
    }

    @Override
    public void execute(PbsInputStream input, PbsOutputStream output, long handleId) throws RemoteException {
        IRemoteJSpaceAdmin admin = (IRemoteJSpaceAdmin)PbsExecuter.IRemoteJSpaceAdminBundle.getInstance(handleId);
        ITemplatePacket template = PbsEntryFormatter.readPbsTemplate((PbsInputStream)input, null);
        boolean includeNotifyTemplates = input.readBoolean();
        int chunkSize = input.readInt();
        SpaceCopyStatus copyStatus = null;
        boolean isProxy = input.readBoolean();
        if (isProxy) {
            ISpaceProxy space = ((SpaceProxyWrapper)PbsExecuter.ISpaceProxyBundle.readInstance(input)).getProxy();
            copyStatus = admin.spaceCopy((IJSpace)space, (Object)template, includeNotifyTemplates, chunkSize);
        } else {
            String remoteUrl = input.readString();
            copyStatus = admin.spaceCopy(remoteUrl, (Object)template, includeNotifyTemplates, chunkSize);
        }
        if (copyStatus != null) {
            output.writeBoolean(true);
            this.serializeCopyResults(output, copyStatus);
        } else {
            output.writeBoolean(false);
        }
    }

    private void serializeCopyResults(PbsOutputStream output, SpaceCopyStatus copyStatus) {
        output.writeInt(copyStatus.getTotalCopyObj());
        output.writeInt(copyStatus.getTotalBlockedEntriesByFilter());
        SpaceURL sourceMemberUrl = copyStatus.getSourceMemberURL();
        if (sourceMemberUrl != null) {
            output.writeString(sourceMemberUrl.getURL());
        } else {
            output.writeString(null);
        }
        Exception ex = copyStatus.getCauseException();
        if (ex != null) {
            output.writeBoolean(true);
            PbsExceptionFormatter.writeException(output, ex, (short)1, false);
        } else {
            output.writeBoolean(false);
        }
        Map duplicateEntries = copyStatus.getTotalDuplicateEntries();
        if (duplicateEntries != null) {
            output.writeBoolean(true);
            Iterator duplicateIterator = duplicateEntries.entrySet().iterator();
            output.writeInt(duplicateEntries.size());
            while (duplicateIterator.hasNext()) {
                Map.Entry entry = duplicateIterator.next();
                output.writeString((String)entry.getKey());
                output.writeString((String)entry.getValue());
            }
        } else {
            output.writeBoolean(false);
        }
        Map totalCopiedEntries = copyStatus.getTotalCopiedEntries();
        if (totalCopiedEntries != null) {
            output.writeBoolean(true);
            Iterator copiedIterator = totalCopiedEntries.entrySet().iterator();
            output.writeInt(totalCopiedEntries.size());
            while (copiedIterator.hasNext()) {
                Map.Entry entry = copiedIterator.next();
                output.writeString((String)entry.getKey());
                output.writeInt(((Integer)entry.getValue()).intValue());
            }
        } else {
            output.writeBoolean(false);
        }
    }
}

