/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.serialization.pbs.executers.ispaceproxy;

import com.gigaspaces.async.AsyncFutureListener;
import com.gigaspaces.async.AsyncResult;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.gigaspaces.internal.transport.PbsEntryPacket;
import com.gigaspaces.serialization.pbs.PbsEntryFormatter;
import com.gigaspaces.serialization.pbs.PbsInputStream;
import com.gigaspaces.serialization.pbs.PbsOutputStream;
import com.gigaspaces.serialization.pbs.commands.DispatcherObjectProxy;
import com.gigaspaces.serialization.pbs.commands.asynccallbacks.OnResult;
import com.gigaspaces.serialization.pbs.executers.AbstractPbsExecuter;
import com.gigaspaces.serialization.pbs.executers.AbstractPbsExecutersBundle;
import com.gigaspaces.serialization.pbs.executers.PbsExecuter;
import com.gigaspaces.serialization.pbs.executers.ispaceproxy.SpaceProxyWrapper;
import java.rmi.RemoteException;
import net.jini.core.transaction.Transaction;

public class ASyncReadTake
extends AbstractPbsExecuter {
    public ASyncReadTake(AbstractPbsExecutersBundle<?> bundle) {
        super(bundle, "ASyncReadTake");
    }

    @Override
    public void execute(PbsInputStream input, PbsOutputStream output, long handleId) throws RemoteException {
        ISpaceProxy spaceProxy = ((SpaceProxyWrapper)PbsExecuter.ISpaceProxyBundle.getInstance(handleId)).getProxy();
        long callbackHandleId = input.readLong();
        int contextAppDomainId = input.readInt();
        ITemplatePacket template = PbsEntryFormatter.readPbsTemplate((PbsInputStream)input, (ISpaceProxy)spaceProxy);
        Transaction txn = (Transaction)PbsExecuter.TransactionBundle.readInstance(input);
        long timeout = input.readLong();
        int modifiers = input.readInt();
        boolean readOperation = input.readBoolean();
        if (readOperation) {
            spaceProxy.asyncRead((Object)template, txn, timeout, modifiers, (AsyncFutureListener)new DispatcherCallbackAsyncFutureListener(callbackHandleId, contextAppDomainId));
        } else {
            spaceProxy.asyncTake((Object)template, txn, timeout, modifiers, (AsyncFutureListener)new DispatcherCallbackAsyncFutureListener(callbackHandleId, contextAppDomainId));
        }
    }

    private static class DispatcherCallbackAsyncFutureListener
    extends DispatcherObjectProxy
    implements AsyncFutureListener<PbsEntryPacket> {
        public DispatcherCallbackAsyncFutureListener(long callbackHandleId, int contextAppDomainId) {
            super((byte)8, callbackHandleId, contextAppDomainId);
        }

        public void onResult(AsyncResult<PbsEntryPacket> result) {
            OnResult.executePbsEntryPacketResult(this, result);
        }
    }
}

