/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.serialization.pbs.executers.ispaceproxy;

import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.gigaspaces.internal.transport.PbsEntryPacket;
import com.gigaspaces.query.aggregators.AbstractPathAggregator;
import com.gigaspaces.query.aggregators.AggregationInternalUtils;
import com.gigaspaces.query.aggregators.AggregationResult;
import com.gigaspaces.query.aggregators.AggregationSet;
import com.gigaspaces.query.aggregators.AverageAggregator;
import com.gigaspaces.query.aggregators.CountAggregator;
import com.gigaspaces.query.aggregators.GroupByAggregator;
import com.gigaspaces.query.aggregators.GroupByKey;
import com.gigaspaces.query.aggregators.GroupByResult;
import com.gigaspaces.query.aggregators.GroupByValue;
import com.gigaspaces.query.aggregators.ListEntriesAggregator;
import com.gigaspaces.query.aggregators.MaxEntryAggregator;
import com.gigaspaces.query.aggregators.MaxValueAggregator;
import com.gigaspaces.query.aggregators.MinEntryAggregator;
import com.gigaspaces.query.aggregators.MinValueAggregator;
import com.gigaspaces.query.aggregators.SpaceEntriesAggregator;
import com.gigaspaces.query.aggregators.SumAggregator;
import com.gigaspaces.serialization.pbs.PbsEntryFormatter;
import com.gigaspaces.serialization.pbs.PbsInputStream;
import com.gigaspaces.serialization.pbs.PbsOutputStream;
import com.gigaspaces.serialization.pbs.executers.AbstractPbsExecuter;
import com.gigaspaces.serialization.pbs.executers.AbstractPbsExecutersBundle;
import com.gigaspaces.serialization.pbs.executers.PbsExecuter;
import com.gigaspaces.serialization.pbs.executers.ispaceproxy.SpaceProxyWrapper;
import java.util.List;

public class Aggregate
extends AbstractPbsExecuter {
    public Aggregate(AbstractPbsExecutersBundle<?> bundle) {
        super(bundle, "Aggregate");
    }

    @Override
    public void execute(PbsInputStream input, PbsOutputStream output, long handleId) throws Exception {
        ISpaceProxy spaceProxy = ((SpaceProxyWrapper)PbsExecuter.ISpaceProxyBundle.getInstance(handleId)).getProxy();
        ITemplatePacket query = PbsEntryFormatter.readPbsTemplate((PbsInputStream)input, (ISpaceProxy)spaceProxy);
        int modifiers = input.readInt();
        AggregationSet aggregationSet = this.readAggregationSet(input);
        AggregationResult result = spaceProxy.aggregate((Object)query, aggregationSet, null, modifiers);
        this.writeResult(output, result, aggregationSet);
    }

    private AggregationSet readAggregationSet(PbsInputStream input) {
        AggregationSet result = new AggregationSet();
        int numOfAggregations = input.readInt();
        for (int i = 0; i < numOfAggregations; ++i) {
            result.add(this.readAggregator(input));
        }
        return result;
    }

    private SpaceEntriesAggregator readAggregator(PbsInputStream input) {
        byte aggregationType = input.readByte();
        switch (aggregationType) {
            case 1: {
                GroupByAggregator groupByAggregator = new GroupByAggregator();
                String[] groupByPaths = new String[input.readInt()];
                for (int i = 0; i < groupByPaths.length; ++i) {
                    groupByPaths[i] = input.readString();
                }
                groupByAggregator.groupBy(groupByPaths);
                int numOfSelectors = input.readInt();
                for (int i = 0; i < numOfSelectors; ++i) {
                    groupByAggregator.select(new SpaceEntriesAggregator[]{this.readAggregator(input)});
                }
                return groupByAggregator;
            }
            case 2: {
                return new CountAggregator().setPath(input.readString());
            }
            case 3: {
                return new SumAggregator().setPath(input.readString());
            }
            case 4: {
                return new AverageAggregator().setPath(input.readString());
            }
            case 5: {
                return new MaxValueAggregator().setPath(input.readString());
            }
            case 6: {
                return new MaxEntryAggregator().setPath(input.readString());
            }
            case 7: {
                return new MinValueAggregator().setPath(input.readString());
            }
            case 8: {
                return new MinEntryAggregator().setPath(input.readString());
            }
            case 9: {
                return new ListEntriesAggregator();
            }
        }
        throw new IllegalArgumentException("Unsupported aggregationType " + aggregationType);
    }

    private void writeResult(PbsOutputStream output, AggregationResult aggregationResult, AggregationSet aggregationSet) {
        List aggregators = AggregationInternalUtils.getAggregators((AggregationSet)aggregationSet);
        output.writeInt(aggregators.size());
        for (int i = 0; i < aggregators.size(); ++i) {
            this.writeAggregatorResult(output, aggregationResult.get(i), (SpaceEntriesAggregator)aggregators.get(i));
        }
    }

    private void writeAggregatorResult(PbsOutputStream output, Object result, SpaceEntriesAggregator aggregator) {
        if (aggregator instanceof GroupByAggregator) {
            this.writeGroupByResult(output, (GroupByResult)result, (GroupByAggregator)aggregator);
        } else if (aggregator instanceof ListEntriesAggregator) {
            List entries = (List)result;
            if (entries == null) {
                output.writeInt(0);
            } else {
                output.writeInt(entries.size());
                for (PbsEntryPacket entry : entries) {
                    PbsEntryFormatter.writePbsEntryPacket((PbsOutputStream)output, (PbsEntryPacket)entry);
                }
            }
        } else if (aggregator instanceof MaxEntryAggregator || aggregator instanceof MinEntryAggregator) {
            PbsEntryFormatter.writeNullablePbsEntryPacket((PbsOutputStream)output, (PbsEntryPacket)((PbsEntryPacket)result));
        } else if (aggregator instanceof AbstractPathAggregator) {
            PbsEntryFormatter.writeFieldValue((PbsOutputStream)output, (Object)result);
        } else {
            throw new UnsupportedOperationException("Unsupported aggregator " + aggregator.getClass().getName());
        }
    }

    private void writeGroupByResult(PbsOutputStream output, GroupByResult groupByResult, GroupByAggregator aggregator) {
        List selectors = AggregationInternalUtils.getSelectors((GroupByAggregator)aggregator);
        output.writeInt(groupByResult.size());
        for (GroupByValue group : groupByResult) {
            int i;
            GroupByKey key = group.getKey();
            for (i = 0; i < key.size(); ++i) {
                PbsEntryFormatter.writeFieldValue((PbsOutputStream)output, (Object)key.get(i));
            }
            for (i = 0; i < group.size(); ++i) {
                this.writeAggregatorResult(output, group.get(i), (SpaceEntriesAggregator)selectors.get(i));
            }
        }
    }
}

