/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.serialization.pbs.executers.ispaceproxy;

import com.gigaspaces.client.ChangeException;
import com.gigaspaces.client.ChangeModifiers;
import com.gigaspaces.client.ChangeOperationResult;
import com.gigaspaces.client.ChangeResult;
import com.gigaspaces.client.ChangeSet;
import com.gigaspaces.client.ChangeSetInternalUtils;
import com.gigaspaces.client.ChangedEntryDetails;
import com.gigaspaces.client.FailedChangedEntryDetails;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.gigaspaces.serialization.pbs.PbsEntryFormatter;
import com.gigaspaces.serialization.pbs.PbsExceptionFormatter;
import com.gigaspaces.serialization.pbs.PbsInputStream;
import com.gigaspaces.serialization.pbs.PbsOutputStream;
import com.gigaspaces.serialization.pbs.executers.AbstractPbsExecuter;
import com.gigaspaces.serialization.pbs.executers.AbstractPbsExecutersBundle;
import com.gigaspaces.serialization.pbs.executers.PbsExecuter;
import com.gigaspaces.serialization.pbs.executers.ispaceproxy.SpaceProxyWrapper;
import com.gigaspaces.sync.change.AddAllToCollectionOperation;
import com.gigaspaces.sync.change.AddToCollectionOperation;
import com.gigaspaces.sync.change.ChangeOperation;
import com.gigaspaces.sync.change.IncrementOperation;
import com.gigaspaces.sync.change.PutInMapOperation;
import com.gigaspaces.sync.change.RemoveFromCollectionOperation;
import com.gigaspaces.sync.change.RemoveFromMapOperation;
import com.gigaspaces.sync.change.SetOperation;
import com.gigaspaces.sync.change.UnsetOperation;
import com.j_spaces.core.client.Modifiers;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import net.jini.core.transaction.Transaction;

public class Change
extends AbstractPbsExecuter {
    private static final byte SET = 0;
    private static final byte UNSET = 1;
    private static final byte INCREMENT = 2;
    private static final byte ADD_TO_COLLECTION = 3;
    private static final byte REMOVE_FROM_COLLECTION = 4;
    private static final byte PUT_IN_MAP = 5;
    private static final byte REMOVE_FROM_MAP = 6;

    public Change(AbstractPbsExecutersBundle<?> bundle) {
        super(bundle, "Change");
    }

    @Override
    public void execute(PbsInputStream input, PbsOutputStream output, long handleId) throws Exception {
        ISpaceProxy spaceProxy = ((SpaceProxyWrapper)PbsExecuter.ISpaceProxyBundle.getInstance(handleId)).getProxy();
        ITemplatePacket template = PbsEntryFormatter.readPbsTemplate((PbsInputStream)input, (ISpaceProxy)spaceProxy);
        Transaction txn = (Transaction)PbsExecuter.TransactionBundle.readInstance(input);
        long timeout = input.readLong();
        ChangeModifiers modifiers = ChangeSetInternalUtils.modifierFromCode((int)input.readInt());
        ChangeSet changeSet = this.readChangeSet(input, spaceProxy);
        try {
            ChangeResult changeResult = spaceProxy.change((Object)template, changeSet, txn, timeout, modifiers);
            output.writeBoolean(true);
            if (changeResult == null) {
                output.writeBoolean(false);
                return;
            }
            output.writeBoolean(true);
            if (Modifiers.contains((int)modifiers.getCode(), (int)0x2000000)) {
                Change.writeDetailedResults(output, changeResult.getResults());
            } else {
                output.writeInt(changeResult.getNumberOfChangedEntries());
            }
        }
        catch (ChangeException e) {
            output.writeBoolean(false);
            PbsExceptionFormatter.writeException(output, e, (short)1, false);
            if (Modifiers.contains((int)modifiers.getCode(), (int)0x2000000)) {
                Change.writeDetailedResults(output, e.getSuccesfullChanges());
            } else {
                output.writeInt(e.getNumSuccesfullChanges());
            }
            Change.writeFailedChanged(output, e.getFailedChanges());
            Change.writeErrors(output, e.getErrors());
        }
    }

    private static void writeErrors(PbsOutputStream output, Collection<Throwable> errors) {
        if (errors == null) {
            output.writeInt(-1);
        } else {
            output.writeInt(errors.size());
            for (Throwable throwable : errors) {
                PbsExceptionFormatter.writeException(output, throwable, (short)1, false);
            }
        }
    }

    private static void writeFailedChanged(PbsOutputStream output, Collection<FailedChangedEntryDetails> failedChanges) {
        if (failedChanges == null) {
            output.writeInt(-1);
        } else {
            output.writeInt(failedChanges.size());
            for (FailedChangedEntryDetails failedEntryDetails : failedChanges) {
                PbsEntryFormatter.writeFieldValue((PbsOutputStream)output, (Object)failedEntryDetails.getId());
                output.writeRepetitiveString(failedEntryDetails.getTypeName());
                output.writeInt(failedEntryDetails.getVersion());
                PbsExceptionFormatter.writeException(output, failedEntryDetails.getCause(), (short)1, false);
            }
        }
    }

    private static void writeDetailedResults(PbsOutputStream output, Collection<ChangedEntryDetails<?>> results) {
        if (results == null) {
            output.writeInt(-1);
        } else {
            output.writeInt(results.size());
            for (ChangedEntryDetails<?> changedEntryDetails : results) {
                PbsEntryFormatter.writeFieldValue((PbsOutputStream)output, (Object)changedEntryDetails.getId());
                output.writeRepetitiveString(changedEntryDetails.getTypeName());
                output.writeInt(changedEntryDetails.getVersion());
                Change.writeChangeOperationResults(output, changedEntryDetails.getChangeOperationsResults());
            }
        }
    }

    private static void writeChangeOperationResults(PbsOutputStream output, List<ChangeOperationResult> changeOperationsResults) {
        if (changeOperationsResults == null) {
            output.writeInt(-1);
        } else {
            output.writeInt(changeOperationsResults.size());
            for (ChangeOperationResult changeOperationResult : changeOperationsResults) {
                ChangeOperation changeOperation = changeOperationResult.getOperation();
                if (IncrementOperation.represents((ChangeOperation)changeOperation)) {
                    PbsEntryFormatter.writeFieldValue((PbsOutputStream)output, (Object)IncrementOperation.getNewValue((ChangeOperationResult)changeOperationResult));
                    continue;
                }
                if (AddToCollectionOperation.represents((ChangeOperation)changeOperation)) {
                    output.writeInt(AddToCollectionOperation.getNewSize((ChangeOperationResult)changeOperationResult));
                    output.writeBoolean(AddToCollectionOperation.isChanged((ChangeOperationResult)changeOperationResult));
                    continue;
                }
                if (AddAllToCollectionOperation.represents((ChangeOperation)changeOperation)) {
                    output.writeInt(AddAllToCollectionOperation.getNewSize((ChangeOperationResult)changeOperationResult));
                    output.writeBoolean(AddAllToCollectionOperation.isChanged((ChangeOperationResult)changeOperationResult));
                    continue;
                }
                if (RemoveFromCollectionOperation.represents((ChangeOperation)changeOperation)) {
                    output.writeInt(RemoveFromCollectionOperation.getNewSize((ChangeOperationResult)changeOperationResult));
                    output.writeBoolean(RemoveFromCollectionOperation.isChanged((ChangeOperationResult)changeOperationResult));
                    continue;
                }
                if (PutInMapOperation.represents((ChangeOperation)changeOperation)) {
                    output.writeInt(PutInMapOperation.getNewSize((ChangeOperationResult)changeOperationResult));
                    PbsEntryFormatter.writeFieldValue((PbsOutputStream)output, (Object)PutInMapOperation.getPreviousValue((ChangeOperationResult)changeOperationResult));
                    continue;
                }
                if (RemoveFromMapOperation.represents((ChangeOperation)changeOperation)) {
                    output.writeInt(RemoveFromMapOperation.getNewSize((ChangeOperationResult)changeOperationResult));
                    PbsEntryFormatter.writeFieldValue((PbsOutputStream)output, (Object)RemoveFromMapOperation.getRemovedValue((ChangeOperationResult)changeOperationResult));
                    continue;
                }
                if (SetOperation.represents((ChangeOperation)changeOperation) || UnsetOperation.represents((ChangeOperation)changeOperation)) continue;
                PbsEntryFormatter.writeFieldValue((PbsOutputStream)output, (Object)changeOperationResult.getResult());
            }
        }
    }

    private ChangeSet readChangeSet(PbsInputStream input, ISpaceProxy spaceProxy) {
        ChangeSet changeSet = new ChangeSet();
        long lease = input.readLong();
        changeSet.lease(lease);
        int mutatorsCount = input.readInt();
        if (mutatorsCount > -1) {
            block9: for (int i = 0; i < mutatorsCount; ++i) {
                byte mutatorType = input.readByte();
                switch (mutatorType) {
                    case 0: {
                        String path = input.readString();
                        Object value = PbsEntryFormatter.readFieldValue((PbsInputStream)input, (ISpaceProxy)spaceProxy);
                        changeSet.set(path, (Serializable)value);
                        continue block9;
                    }
                    case 1: {
                        String path = input.readString();
                        changeSet.unset(path);
                        continue block9;
                    }
                    case 2: {
                        String path = input.readString();
                        Object delta = PbsEntryFormatter.readFieldValue((PbsInputStream)input, (ISpaceProxy)spaceProxy);
                        changeSet.increment(path, (Number)delta);
                        continue block9;
                    }
                    case 3: {
                        String path = input.readString();
                        Object newItem = PbsEntryFormatter.readFieldValue((PbsInputStream)input, (ISpaceProxy)spaceProxy);
                        if (input.readBoolean()) {
                            if (newItem instanceof Collection) {
                                changeSet.addAllToCollection(path, (Collection)newItem);
                                continue block9;
                            }
                            if (newItem instanceof Object[]) {
                                changeSet.addAllToCollection(path, (Serializable[])newItem);
                                continue block9;
                            }
                            throw new IllegalArgumentException("Cannot AddRange using type - " + newItem.getClass());
                        }
                        changeSet.addToCollection(path, (Serializable)newItem);
                        continue block9;
                    }
                    case 4: {
                        String path = input.readString();
                        Object itemToRemove = PbsEntryFormatter.readFieldValue((PbsInputStream)input, (ISpaceProxy)spaceProxy);
                        changeSet.removeFromCollection(path, (Serializable)itemToRemove);
                        continue block9;
                    }
                    case 5: {
                        String path = input.readString();
                        Object key = PbsEntryFormatter.readFieldValue((PbsInputStream)input, (ISpaceProxy)spaceProxy);
                        Object value = PbsEntryFormatter.readFieldValue((PbsInputStream)input, (ISpaceProxy)spaceProxy);
                        changeSet.putInMap(path, (Serializable)key, (Serializable)value);
                        continue block9;
                    }
                    case 6: {
                        String path = input.readString();
                        Object key = PbsEntryFormatter.readFieldValue((PbsInputStream)input, (ISpaceProxy)spaceProxy);
                        changeSet.removeFromMap(path, (Serializable)key);
                        continue block9;
                    }
                }
            }
        }
        return changeSet;
    }
}

