/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.serialization.pbs.executers.ispaceproxy;

import com.gigaspaces.internal.client.cache.SpaceCacheFactory;
import com.gigaspaces.internal.client.cache.localcache.LocalCacheConfig;
import com.gigaspaces.internal.client.cache.localcache.LocalCacheContainer;
import com.gigaspaces.internal.client.spaceproxy.IDirectSpaceProxy;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.serialization.pbs.PbsInputStream;
import com.gigaspaces.serialization.pbs.PbsOutputStream;
import com.gigaspaces.serialization.pbs.executers.AbstractPbsExecuter;
import com.gigaspaces.serialization.pbs.executers.AbstractPbsExecutersBundle;
import com.gigaspaces.serialization.pbs.executers.PbsExecuter;
import com.gigaspaces.serialization.pbs.executers.ispaceproxy.SpaceProxyWrapper;
import java.util.UUID;

public class CreateLocalCache
extends AbstractPbsExecuter {
    public CreateLocalCache(AbstractPbsExecutersBundle<?> bundle) {
        super(bundle, "CreateLocalCache");
    }

    @Override
    public void execute(PbsInputStream input, PbsOutputStream output, long handleId) throws Exception {
        SpaceProxyWrapper remoteSpaceWrapper = (SpaceProxyWrapper)PbsExecuter.ISpaceProxyBundle.readInstance(input);
        ISpaceProxy remoteSpace = remoteSpaceWrapper.getProxy();
        Integer batchSize = input.readNullableInt();
        Long batchTimeout = input.readNullableLong();
        Long maxDisconnectionDuration = input.readNullableLong();
        Long maxTimeToLive = input.readNullableLong();
        Integer updateMode = input.readNullableInt();
        UUID processingUnitIdentifierContext = input.readNullableUUID();
        int appDomainId = input.readInt();
        LocalCacheConfig config = new LocalCacheConfig();
        config.setBatchSize(batchSize);
        config.setBatchTimeout(batchTimeout);
        config.setMaxDisconnectionDuration(maxDisconnectionDuration);
        config.setMaxTimeToLive(maxTimeToLive);
        config.setUpdateMode(updateMode);
        config.setStorageType("shallowCopy");
        LocalCacheContainer proxy = SpaceCacheFactory.createLocalCache((IDirectSpaceProxy)((IDirectSpaceProxy)remoteSpace), (LocalCacheConfig)config);
        PbsExecuter.ISpaceProxyBundle.addAndSerializeProxyProperties(output, (ISpaceProxy)proxy, processingUnitIdentifierContext, appDomainId);
    }
}

