/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.serialization.pbs.executers.ispaceproxy;

import com.gigaspaces.internal.client.cache.AbstractSpaceCacheContainer;
import com.gigaspaces.internal.client.cache.SpaceCacheFactory;
import com.gigaspaces.internal.client.cache.localview.LocalViewConfig;
import com.gigaspaces.internal.client.spaceproxy.IDirectSpaceProxy;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.gigaspaces.serialization.pbs.PbsEntryFormatter;
import com.gigaspaces.serialization.pbs.PbsInputStream;
import com.gigaspaces.serialization.pbs.PbsOutputStream;
import com.gigaspaces.serialization.pbs.executers.AbstractPbsExecuter;
import com.gigaspaces.serialization.pbs.executers.AbstractPbsExecutersBundle;
import com.gigaspaces.serialization.pbs.executers.PbsExecuter;
import com.gigaspaces.serialization.pbs.executers.ispaceproxy.SpaceProxyWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class CreateLocalView
extends AbstractPbsExecuter {
    public CreateLocalView(AbstractPbsExecutersBundle<?> bundle) {
        super(bundle, "CreateLocalView");
    }

    @Override
    public void execute(PbsInputStream input, PbsOutputStream output, long handleId) throws Exception {
        SpaceProxyWrapper remoteSpaceWrapper = (SpaceProxyWrapper)PbsExecuter.ISpaceProxyBundle.readInstance(input);
        ISpaceProxy remoteSpace = remoteSpaceWrapper.getProxy();
        List<Object> viewQueries = CreateLocalView.readViewQueries(input, remoteSpace);
        Integer batchSize = input.readNullableInt();
        Long batchTimeout = input.readNullableLong();
        Long maxDisconnectionDuration = input.readNullableLong();
        Long initialSynchronizationTimeout = input.readNullableLong();
        UUID processingUnitIdentifierContext = input.readNullableUUID();
        int appDomainId = input.readInt();
        LocalViewConfig config = new LocalViewConfig();
        config.setViewQueries(viewQueries);
        config.setBatchSize(batchSize);
        config.setBatchTimeout(batchTimeout);
        config.setMaxDisconnectionDuration(maxDisconnectionDuration);
        config.setInitialSynchronizationTimeout(initialSynchronizationTimeout);
        config.setStorageType("shallowCopy");
        AbstractSpaceCacheContainer proxy = SpaceCacheFactory.createLocalView((IDirectSpaceProxy)((IDirectSpaceProxy)remoteSpace), (LocalViewConfig)config);
        PbsExecuter.ISpaceProxyBundle.addAndSerializeProxyProperties(output, (ISpaceProxy)proxy, processingUnitIdentifierContext, appDomainId);
    }

    private static List<Object> readViewQueries(PbsInputStream input, ISpaceProxy spaceProxy) {
        int length = input.readInt();
        ArrayList<Object> queries = new ArrayList<Object>(length);
        for (int i = 0; i < length; ++i) {
            ITemplatePacket query = PbsEntryFormatter.readPbsTemplate((PbsInputStream)input, (ISpaceProxy)spaceProxy, null);
            queries.add(query);
        }
        return queries;
    }
}

