/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.serialization.pbs.executers.ispaceproxy;

import com.gigaspaces.client.ClusterConfig;
import com.gigaspaces.client.SpaceProxyFactory;
import com.gigaspaces.datasource.ManagedDataSource;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.cluster.node.impl.gateway.GatewayConfig;
import com.gigaspaces.internal.cluster.node.impl.gateway.GatewayPolicy;
import com.gigaspaces.internal.cluster.node.impl.gateway.GatewaysPolicy;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.interop.dotnet.datasource.DotNetDataSourceAdapter;
import com.gigaspaces.interop.dotnet.datasource.DotNetManagedDataSourceAdapter;
import com.gigaspaces.interop.dotnet.filters.DotNetSpaceFilterAdapter;
import com.gigaspaces.metadata.SpaceTypeDescriptor;
import com.gigaspaces.security.directory.CredentialsProvider;
import com.gigaspaces.security.directory.DefaultCredentialsProvider;
import com.gigaspaces.serialization.pbs.PbsEntryFormatter;
import com.gigaspaces.serialization.pbs.PbsInputStream;
import com.gigaspaces.serialization.pbs.PbsOutputStream;
import com.gigaspaces.serialization.pbs.commands.DispatcherObjectProxy;
import com.gigaspaces.serialization.pbs.executers.AbstractPbsExecuter;
import com.gigaspaces.serialization.pbs.executers.AbstractPbsExecutersBundle;
import com.gigaspaces.serialization.pbs.executers.PbsExecuter;
import com.gigaspaces.server.SpaceCustomComponent;
import com.j_spaces.core.cluster.RedoLogCapacityExceededPolicy;
import com.j_spaces.core.exception.internal.PBSInternalSpaceException;
import com.j_spaces.core.filters.FilterProvider;
import com.j_spaces.core.filters.ISpaceFilter;
import java.util.Properties;
import java.util.UUID;

public class CreateSpace
extends AbstractPbsExecuter {
    private static final byte ISqlDataSourceImpl = 0;
    private static final byte IManagedDataSourceImpl = 1;

    public CreateSpace(AbstractPbsExecutersBundle<?> bundle) {
        super(bundle, "CreateSpace");
    }

    @Override
    public void execute(PbsInputStream input, PbsOutputStream output, long handleId) throws Exception {
        SpaceProxyFactory factory = new SpaceProxyFactory();
        UUID processingUnitIdentifierContext = input.readNullableUUID();
        int appDomainId = input.readInt();
        boolean isRemote = input.readBoolean();
        String name = input.readString();
        if (isRemote) {
            factory.setInstanceId(input.readString());
        }
        factory.setProperties(input.readProperties());
        factory.setLookupGroups(input.readString());
        factory.setLookupLocators(input.readString());
        factory.setLookupTimeout(input.readNullableInt());
        factory.setVersioned(input.readNullableBoolean());
        factory.setCredentialsProvider(CreateSpace.readCredentials(input));
        if (!isRemote) {
            factory.setSchema(input.readString());
            factory.setMirror(input.readNullableBoolean());
            factory.setSecured(input.readNullableBoolean());
            factory.setClusterConfig(CreateSpace.readClusterConfig(input));
            factory.setTypeDescriptors(CreateSpace.readTypeDescriptors(input));
            factory.setFilterProviders(CreateSpace.readFilters(input));
            factory.addCustomComponent((SpaceCustomComponent)CreateSpace.readGateway(input));
            factory.setExternalDataSource(CreateSpace.readExternalDataSource(input));
        }
        ISpaceProxy proxy = factory.createSpaceProxy(name, isRemote);
        PbsExecuter.ISpaceProxyBundle.addAndSerializeProxyProperties(output, proxy, processingUnitIdentifierContext, appDomainId);
    }

    public static CredentialsProvider readCredentials(PbsInputStream input) {
        if (!input.readBoolean()) {
            return null;
        }
        String name = input.readString();
        String password = input.readString();
        return new DefaultCredentialsProvider(name, password);
    }

    public static ClusterConfig readClusterConfig(PbsInputStream input) {
        if (!input.readBoolean()) {
            return null;
        }
        ClusterConfig clusterConfig = new ClusterConfig();
        clusterConfig.setSchema(input.readString());
        clusterConfig.setNumberOfInstances(input.readNullableInt());
        clusterConfig.setNumberOfBackups(input.readNullableInt());
        clusterConfig.setInstanceId(input.readNullableInt());
        clusterConfig.setBackupId(input.readNullableInt());
        return clusterConfig;
    }

    public static SpaceTypeDescriptor[] readTypeDescriptors(PbsInputStream input) {
        SpaceTypeDescriptor[] typeDescriptors = null;
        int numOfTypeDescriptors = input.readInt();
        if (numOfTypeDescriptors >= 0) {
            typeDescriptors = new SpaceTypeDescriptor[numOfTypeDescriptors];
            for (int i = 0; i < numOfTypeDescriptors; ++i) {
                typeDescriptors[i] = PbsEntryFormatter.readTypeDescriptor((PbsInputStream)input);
            }
        }
        return typeDescriptors;
    }

    public static FilterProvider[] readFilters(PbsInputStream input) {
        FilterProvider[] filters = null;
        int numOfFilters = input.readInt();
        if (numOfFilters >= 0) {
            filters = new FilterProvider[numOfFilters];
            for (int i = 0; i < numOfFilters; ++i) {
                long filterHandleId = input.readLong();
                int contextAppDomain = input.readInt();
                String name = input.readString();
                boolean isActiveWhenBackup = input.readBoolean();
                boolean enabled = input.readBoolean();
                boolean isSecurityFilter = input.readBoolean();
                boolean isShutdownSpaceOnInitFailure = input.readBoolean();
                int priority = input.readInt();
                int[] opCodes = input.readIntArray();
                Properties customProperties = input.readProperties();
                DotNetSpaceFilterAdapter spaceFilter = new DotNetSpaceFilterAdapter(filterHandleId, contextAppDomain, customProperties);
                filters[i] = new FilterProvider(name, (ISpaceFilter)spaceFilter);
                filters[i].setEnabled(enabled);
                filters[i].setActiveWhenBackup(isActiveWhenBackup);
                filters[i].setSecurityFilter(isSecurityFilter);
                filters[i].setShutdownSpaceOnInitFailure(isShutdownSpaceOnInitFailure);
                filters[i].setPriority(priority);
                filters[i].setOpCodes(opCodes);
            }
        }
        return filters;
    }

    public static GatewayConfig readGateway(PbsInputStream input) {
        boolean hasGatewaysPolicy = input.readBoolean();
        if (!hasGatewaysPolicy) {
            return null;
        }
        GatewayPolicy defaultGatewayPolicy = CreateSpace.readSingleGatewayPolicy(input);
        GatewayPolicy[] targets = null;
        int numOfTargets = input.readInt();
        if (numOfTargets >= 0) {
            targets = new GatewayPolicy[numOfTargets];
            for (int i = 0; i < numOfTargets; ++i) {
                GatewayPolicy target;
                targets[i] = target = CreateSpace.readSingleGatewayPolicy(input);
            }
        }
        GatewaysPolicy gateway = new GatewaysPolicy();
        gateway.setLocalSiteName(defaultGatewayPolicy.getGatewayName());
        gateway.setGatewayPolicies(targets);
        gateway.setDefaultGatewayPolicy(defaultGatewayPolicy);
        return new GatewayConfig().setGatewaysPolicy(gateway);
    }

    private static GatewayPolicy readSingleGatewayPolicy(PbsInputStream input) {
        Boolean replicateChangeAsUpdate;
        Integer onRedoLogCapacityExceededCode;
        RedoLogCapacityExceededPolicy onRedoLogCapacityExceeded;
        Long maxRedoLogCapacity;
        Integer pendingOperationThreshold;
        Long idleTimeThreshold;
        GatewayPolicy target = new GatewayPolicy();
        target.setGatewayName(input.readString());
        Integer bulkSize = input.readNullableInt();
        if (bulkSize != null) {
            target.setBulkSize(bulkSize.intValue());
        }
        if ((idleTimeThreshold = input.readNullableLong()) != null) {
            target.setIdleTimeThreshold(idleTimeThreshold.longValue());
        }
        if ((pendingOperationThreshold = input.readNullableInt()) != null) {
            target.setPendingOperationThreshold(pendingOperationThreshold.intValue());
        }
        if ((maxRedoLogCapacity = input.readNullableLong()) != null) {
            target.setMaxRedoLogCapacity(maxRedoLogCapacity.longValue());
        }
        if ((onRedoLogCapacityExceeded = RedoLogCapacityExceededPolicy.fromCode((Integer)(onRedoLogCapacityExceededCode = input.readNullableInt()))) != null) {
            target.setOnRedoLogCapacityExceeded(onRedoLogCapacityExceeded);
        }
        if ((replicateChangeAsUpdate = input.readNullableBoolean()) != null) {
            target.setReplicateChangeAsUpdate(replicateChangeAsUpdate.booleanValue());
        }
        return target;
    }

    public static ManagedDataSource<IEntryPacket> readExternalDataSource(PbsInputStream input) {
        DispatcherObjectProxy dataSource;
        boolean hasExternalDataSource = input.readBoolean();
        if (!hasExternalDataSource) {
            return null;
        }
        long edsHandleId = input.readLong();
        int contextAppDomainId = input.readInt();
        Properties customProperties = input.readProperties();
        byte implementedInterfaceType = input.readByte();
        switch (implementedInterfaceType) {
            case 0: {
                dataSource = new DotNetDataSourceAdapter(edsHandleId, contextAppDomainId, customProperties);
                break;
            }
            case 1: {
                dataSource = new DotNetManagedDataSourceAdapter(edsHandleId, contextAppDomainId, customProperties);
                break;
            }
            default: {
                throw new PBSInternalSpaceException("Received illegal implemented interface type code: " + implementedInterfaceType);
            }
        }
        return dataSource;
    }
}

