/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.serialization.pbs.executers.ispaceproxy;

import com.gigaspaces.async.AsyncFuture;
import com.gigaspaces.async.AsyncFutureListener;
import com.gigaspaces.async.AsyncResult;
import com.gigaspaces.executor.SpaceTask;
import com.gigaspaces.executor.dotnet.DotNetDistributedSpaceTaskAdapter;
import com.gigaspaces.executor.dotnet.DotNetFilteredDistributedSpaceTaskAdapter;
import com.gigaspaces.executor.dotnet.DotNetSpaceTaskAdapter;
import com.gigaspaces.executor.dotnet.DotNetSpaceTaskAdapterResult;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.metadata.converter.ConversionException;
import com.gigaspaces.metadata.SpaceMetadataException;
import com.gigaspaces.serialization.pbs.PbsEntryFormatter;
import com.gigaspaces.serialization.pbs.PbsExceptionFormatter;
import com.gigaspaces.serialization.pbs.PbsInputStream;
import com.gigaspaces.serialization.pbs.PbsOutputStream;
import com.gigaspaces.serialization.pbs.commands.DispatcherObjectProxy;
import com.gigaspaces.serialization.pbs.commands.asynccallbacks.OnResult;
import com.gigaspaces.serialization.pbs.commands.executorcallbacks.ExecutorCallbacksBundle;
import com.gigaspaces.serialization.pbs.executers.AbstractPbsExecuter;
import com.gigaspaces.serialization.pbs.executers.AbstractPbsExecutersBundle;
import com.gigaspaces.serialization.pbs.executers.PbsExecuter;
import com.gigaspaces.serialization.pbs.executers.ispaceproxy.SpaceProxyWrapper;
import java.io.Externalizable;
import java.rmi.RemoteException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.TransactionException;

public class ExecuteTask
extends AbstractPbsExecuter {
    private static final int INFINITE = -1;

    public ExecuteTask(AbstractPbsExecutersBundle<?> bundle) {
        super(bundle, "ExecuteTask");
    }

    @Override
    public void execute(PbsInputStream input, PbsOutputStream output, long handleId) throws RemoteException, TransactionException, InterruptedException, ExecutionException {
        Object listener;
        Externalizable task;
        ISpaceProxy spaceProxy = ((SpaceProxyWrapper)PbsExecuter.ISpaceProxyBundle.getInstance(handleId)).getProxy();
        long callbackHandleId = -1L;
        int contextAppDomainId = -1;
        int timeout = -1;
        boolean blockingMode = input.readBoolean();
        if (!blockingMode) {
            callbackHandleId = input.readLong();
            contextAppDomainId = input.readInt();
        } else {
            timeout = input.readInt();
        }
        Transaction txn = (Transaction)PbsExecuter.TransactionBundle.readInstance(input);
        byte taskType = input.readByte();
        byte[] serializedDotnetSpaceTask = input.readByteArray();
        Object routing = null;
        if (taskType == 1) {
            try {
                routing = PbsEntryFormatter.readFieldValue((PbsInputStream)input, (ISpaceProxy)spaceProxy);
            }
            catch (ConversionException e) {
                throw new IllegalArgumentException("Failed to resolve space task routing, the routing value must be one of the interoperability supported types as described in the documentation (CLR basic types).", e);
            }
            catch (SpaceMetadataException e) {
                throw new IllegalArgumentException("Failed to resolve space task routing, the routing value must be one of the interoperability supported types as described in the documentation (CLR basic types).", e);
            }
        }
        if (taskType == 1) {
            task = new DotNetSpaceTaskAdapter(serializedDotnetSpaceTask);
            listener = blockingMode ? null : new DispatcherCallbackAsyncFutureListener(callbackHandleId, contextAppDomainId);
        } else {
            task = taskType == 2 ? new DotNetDistributedSpaceTaskAdapter(serializedDotnetSpaceTask, callbackHandleId, contextAppDomainId) : new DotNetFilteredDistributedSpaceTaskAdapter(serializedDotnetSpaceTask, callbackHandleId, contextAppDomainId);
            listener = blockingMode ? null : new EmptyAsyncResultListener();
        }
        AsyncFuture future = spaceProxy.execute((SpaceTask)task, routing, txn, (AsyncFutureListener)listener);
        if (!blockingMode) {
            return;
        }
        try {
            DotNetSpaceTaskAdapterResult result = timeout == -1 ? (DotNetSpaceTaskAdapterResult)future.get() : (DotNetSpaceTaskAdapterResult)future.get((long)timeout, TimeUnit.MILLISECONDS);
            ExecutorCallbacksBundle.serializeDotNetSpaceTaskAdapterResult(output, result);
        }
        catch (TimeoutException e) {
            PbsExceptionFormatter.writeException(output, e, (short)81, true);
        }
    }

    public static class EmptyAsyncResultListener<T>
    implements AsyncFutureListener<T> {
        public void onResult(AsyncResult<T> result) {
        }
    }

    private static class DispatcherCallbackAsyncFutureListener
    extends DispatcherObjectProxy
    implements AsyncFutureListener<DotNetSpaceTaskAdapterResult> {
        public DispatcherCallbackAsyncFutureListener(long callbackHandleId, int contextAppDomainId) {
            super((byte)8, callbackHandleId, contextAppDomainId);
        }

        public void onResult(AsyncResult<DotNetSpaceTaskAdapterResult> result) {
            OnResult.executeSpaceTaskAdapterResult(this, result);
        }
    }

    private static class TaskType {
        public static final byte Simple = 1;
        public static final byte Distributed = 2;
        public static final byte DistributedFiltered = 3;

        private TaskType() {
        }
    }
}

