/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.serialization.pbs.executers.ispaceproxy;

import com.gigaspaces.datasource.ManagedDataSource;
import com.gigaspaces.internal.client.cache.SpaceCacheConfig;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.server.space.SpaceInstanceConfig;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.security.directory.CredentialsProvider;
import com.gigaspaces.serialization.pbs.PbsInputStream;
import com.gigaspaces.serialization.pbs.PbsOutputStream;
import com.gigaspaces.serialization.pbs.executers.AbstractPbsExecuter;
import com.gigaspaces.serialization.pbs.executers.AbstractPbsExecutersBundle;
import com.gigaspaces.serialization.pbs.executers.PbsExecuter;
import com.gigaspaces.serialization.pbs.executers.ispaceproxy.CreateSpace;
import com.gigaspaces.server.SpaceCustomComponent;
import com.j_spaces.core.client.FinderException;
import com.j_spaces.core.client.SpaceFinder;
import com.j_spaces.core.client.SpaceURL;
import com.j_spaces.core.client.SpaceURLParser;
import com.j_spaces.core.filters.FilterProvider;
import java.net.MalformedURLException;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.logging.Level;

public class FindSpace
extends AbstractPbsExecuter {
    public FindSpace(AbstractPbsExecutersBundle<?> bundle) {
        super(bundle, "FindSpace");
    }

    @Override
    public void execute(PbsInputStream input, PbsOutputStream output, long handleId) throws FinderException {
        String url = input.readString();
        CredentialsProvider credentialsProvider = CreateSpace.readCredentials(input);
        Properties properties = FindSpace.readSpaceProperties(input);
        UUID processingUnitIdentifierContext = input.readNullableUUID();
        int appDomainId = input.readInt();
        try {
            SpaceURL spaceURL = SpaceURLParser.parseURL((String)url, (Properties)properties);
            if (spaceURL.getProperty("useLocalCache") != null) {
                spaceURL.getCustomProperties().setProperty(SpaceCacheConfig.FROM_DOTNET, Boolean.TRUE.toString());
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("creating a space proxy with url [" + url + "] associated to pu context " + processingUnitIdentifierContext);
            }
            ISpaceProxy proxy = (ISpaceProxy)SpaceFinder.find((SpaceURL)spaceURL, (CredentialsProvider)credentialsProvider);
            PbsExecuter.ISpaceProxyBundle.addAndSerializeProxyProperties(output, proxy, processingUnitIdentifierContext, appDomainId);
        }
        catch (MalformedURLException e) {
            throw new FinderException("Failed to validate space url: " + e.getMessage(), (Throwable)e);
        }
    }

    private static Properties readSpaceProperties(PbsInputStream input) {
        Properties customProperties;
        Properties properties = new Properties();
        boolean hasSpaceConfig = input.readBoolean();
        if (hasSpaceConfig) {
            FilterProvider[] filters;
            SpaceInstanceConfig spaceInstanceConfig = new SpaceInstanceConfig();
            properties.put("space-config", spaceInstanceConfig);
            ManagedDataSource<IEntryPacket> dataSource = CreateSpace.readExternalDataSource(input);
            if (dataSource != null) {
                properties.put("external-data-source.data-source", dataSource);
            }
            if ((filters = CreateSpace.readFilters(input)) != null && filters.length != 0) {
                properties.put("filter-providers", filters);
            }
            spaceInstanceConfig.setTypeDescriptors(CreateSpace.readTypeDescriptors(input));
            spaceInstanceConfig.addCustomComponent((SpaceCustomComponent)CreateSpace.readGateway(input));
        }
        if ((customProperties = input.readProperties()) != null) {
            properties.putAll((Map<?, ?>)customProperties);
        }
        return properties;
    }
}

