/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.serialization.pbs.executers.ispaceproxy;

import com.gigaspaces.cluster.activeelection.ISpaceModeListener;
import com.gigaspaces.internal.client.spaceproxy.AbstractSpaceProxy;
import com.gigaspaces.internal.client.spaceproxy.IDirectSpaceProxy;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.server.space.SpaceImpl;
import com.gigaspaces.serialization.pbs.PbsInputStream;
import com.gigaspaces.serialization.pbs.PbsOutputStream;
import com.gigaspaces.serialization.pbs.executers.AbstractPbsExecuter;
import com.gigaspaces.serialization.pbs.executers.AbstractPbsExecutersBundle;
import com.gigaspaces.serialization.pbs.executers.ispaceproxy.ASyncReadTake;
import com.gigaspaces.serialization.pbs.executers.ispaceproxy.Aggregate;
import com.gigaspaces.serialization.pbs.executers.ispaceproxy.Change;
import com.gigaspaces.serialization.pbs.executers.ispaceproxy.Clean;
import com.gigaspaces.serialization.pbs.executers.ispaceproxy.Clear;
import com.gigaspaces.serialization.pbs.executers.ispaceproxy.Count;
import com.gigaspaces.serialization.pbs.executers.ispaceproxy.CreateLocalCache;
import com.gigaspaces.serialization.pbs.executers.ispaceproxy.CreateLocalTransactionManager;
import com.gigaspaces.serialization.pbs.executers.ispaceproxy.CreateLocalView;
import com.gigaspaces.serialization.pbs.executers.ispaceproxy.CreateSpace;
import com.gigaspaces.serialization.pbs.executers.ispaceproxy.ExecuteTask;
import com.gigaspaces.serialization.pbs.executers.ispaceproxy.FindSpace;
import com.gigaspaces.serialization.pbs.executers.ispaceproxy.GetClusteredProxy;
import com.gigaspaces.serialization.pbs.executers.ispaceproxy.GetDirectProxy;
import com.gigaspaces.serialization.pbs.executers.ispaceproxy.GetTypeDescriptor;
import com.gigaspaces.serialization.pbs.executers.ispaceproxy.Ping;
import com.gigaspaces.serialization.pbs.executers.ispaceproxy.Read;
import com.gigaspaces.serialization.pbs.executers.ispaceproxy.ReadById;
import com.gigaspaces.serialization.pbs.executers.ispaceproxy.ReadByIds;
import com.gigaspaces.serialization.pbs.executers.ispaceproxy.ReadMultiple;
import com.gigaspaces.serialization.pbs.executers.ispaceproxy.RegisterToSpaceModeEvents;
import com.gigaspaces.serialization.pbs.executers.ispaceproxy.RegisterTypeDescriptor;
import com.gigaspaces.serialization.pbs.executers.ispaceproxy.SetContextClassLoader;
import com.gigaspaces.serialization.pbs.executers.ispaceproxy.SetProperties;
import com.gigaspaces.serialization.pbs.executers.ispaceproxy.SetSecurityContext;
import com.gigaspaces.serialization.pbs.executers.ispaceproxy.Shutdown;
import com.gigaspaces.serialization.pbs.executers.ispaceproxy.Snapshot;
import com.gigaspaces.serialization.pbs.executers.ispaceproxy.SpaceProxyWrapper;
import com.gigaspaces.serialization.pbs.executers.ispaceproxy.Take;
import com.gigaspaces.serialization.pbs.executers.ispaceproxy.TakeById;
import com.gigaspaces.serialization.pbs.executers.ispaceproxy.TakeByIds;
import com.gigaspaces.serialization.pbs.executers.ispaceproxy.TakeMultiple;
import com.gigaspaces.serialization.pbs.executers.ispaceproxy.Update;
import com.gigaspaces.serialization.pbs.executers.ispaceproxy.UpdateLease;
import com.gigaspaces.serialization.pbs.executers.ispaceproxy.UpdateMultiple;
import com.gigaspaces.serialization.pbs.executers.ispaceproxy.Write;
import com.gigaspaces.serialization.pbs.executers.ispaceproxy.WriteMultiple;
import com.j_spaces.core.IStubHandler;
import com.j_spaces.core.admin.IInternalRemoteJSpaceAdmin;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.UUID;
import java.util.logging.Level;

public class ISpaceProxyBundle
extends AbstractPbsExecutersBundle<SpaceProxyWrapper> {
    public ISpaceProxyBundle(byte bundleCode) {
        super(bundleCode, "SpaceProxy");
    }

    @Override
    protected AbstractPbsExecuter[] initExecuters() {
        AbstractPbsExecuter[] executers = new AbstractPbsExecuter[37];
        executers[1] = new FindSpace(this);
        executers[2] = new SetProperties(this);
        executers[3] = new Write(this);
        executers[4] = new Read(this);
        executers[5] = new Take(this);
        executers[6] = new Update(this);
        executers[7] = new WriteMultiple(this);
        executers[8] = new ReadMultiple(this);
        executers[9] = new TakeMultiple(this);
        executers[10] = new UpdateMultiple(this);
        executers[11] = new Clear(this);
        executers[12] = new Clean(this);
        executers[13] = new CreateLocalTransactionManager(this);
        executers[14] = new Ping(this);
        executers[15] = new Count(this);
        executers[16] = new Snapshot(this);
        executers[17] = new GetDirectProxy(this);
        executers[18] = new SetSecurityContext(this);
        executers[19] = new Shutdown(this);
        executers[20] = new RegisterToSpaceModeEvents(this);
        executers[21] = new SetContextClassLoader(this);
        executers[22] = new ASyncReadTake(this);
        executers[23] = new ReadById(this);
        executers[24] = new TakeById(this);
        executers[25] = new ExecuteTask(this);
        executers[26] = new ReadByIds(this);
        executers[27] = new TakeByIds(this);
        executers[28] = new RegisterTypeDescriptor(this);
        executers[29] = new GetTypeDescriptor(this);
        executers[30] = new CreateLocalView(this);
        executers[31] = new UpdateLease(this);
        executers[32] = new Change(this);
        executers[33] = new GetClusteredProxy(this);
        executers[34] = new CreateLocalCache(this);
        executers[35] = new Aggregate(this);
        executers[36] = new CreateSpace(this);
        return executers;
    }

    @Override
    public void destruct(SpaceProxyWrapper instance, long handleId, boolean disposing, PbsInputStream input, PbsOutputStream output) throws RemoteException {
        ISpaceModeListener listener = instance.getListener();
        ISpaceModeListener remoteListener = instance.getRemoteListener();
        ISpaceProxy proxy = instance.getProxy();
        if (remoteListener != null || listener != null) {
            if (remoteListener != null) {
                ((IInternalRemoteJSpaceAdmin)proxy.getDirectProxy().getNonClusteredProxy().getAdmin()).removeSpaceModeListener(remoteListener);
            }
            IStubHandler stubHandler = instance.getStubHandler();
            if (listener != null && stubHandler != null) {
                stubHandler.unexportObject((Remote)listener);
            }
        }
        if (disposing) {
            proxy.close();
        }
    }

    public long addAndSerializeProxyProperties(PbsOutputStream output, ISpaceProxy proxy, UUID processingUnitIdentifierContext) {
        long handleId = this.addInstance(new SpaceProxyWrapper(proxy, processingUnitIdentifierContext), output);
        output.writeBoolean(proxy instanceof AbstractSpaceProxy && ((AbstractSpaceProxy)proxy).isLocalCacheCacheContainer());
        output.writeBoolean(proxy instanceof AbstractSpaceProxy && ((AbstractSpaceProxy)proxy).isLocalViewContainer());
        output.writeBoolean(proxy.isClustered());
        output.writeBoolean(proxy.isEmbedded());
        output.writeBoolean(proxy.isSecured());
        output.writeString(proxy.getName());
        output.writeLong(proxy.getDirectProxy().getClientID());
        output.writeString(proxy.getReferentUuid().toString());
        output.writeString(proxy.getURL() != null ? proxy.getURL().getURL() : null);
        output.writeString(proxy.getFinderURL() != null ? proxy.getFinderURL().getURL() : null);
        output.writeBoolean(proxy.isFifo());
        output.writeBoolean(proxy.isOptimisticLockingEnabled());
        output.writeInt(proxy.getReadModifiers());
        output.writeInt(proxy.getUpdateModifiers());
        return handleId;
    }

    public long addAndSerializeProxyProperties(PbsOutputStream output, ISpaceProxy proxy, UUID processingUnitIdentifierContext, int appDomainId) {
        ISpaceProxyBundle.associateAppDomain(proxy, appDomainId);
        return this.addAndSerializeProxyProperties(output, proxy, processingUnitIdentifierContext);
    }

    private static void associateAppDomain(ISpaceProxy proxy, int appDomainId) {
        SpaceImpl spaceImpl = proxy.getDirectProxy().getSpaceImplIfEmbedded();
        if (spaceImpl == null) {
            return;
        }
        try {
            IDirectSpaceProxy embeddedProxy = spaceImpl.getSingleProxy();
            if (!embeddedProxy.hasAssociatedAppDomain()) {
                embeddedProxy.setAppDomainId(appDomainId);
            }
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("Associated space proxy " + embeddedProxy + " to AppDomain " + appDomainId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }
}

