/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.serialization.pbs.executers.ispaceproxy;

import com.gigaspaces.client.ReadMultipleException;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.gigaspaces.serialization.pbs.PbsEntryFormatter;
import com.gigaspaces.serialization.pbs.PbsExceptionFormatter;
import com.gigaspaces.serialization.pbs.PbsInputStream;
import com.gigaspaces.serialization.pbs.PbsOutputStream;
import com.gigaspaces.serialization.pbs.executers.AbstractPbsExecuter;
import com.gigaspaces.serialization.pbs.executers.AbstractPbsExecutersBundle;
import com.gigaspaces.serialization.pbs.executers.PbsExecuter;
import com.gigaspaces.serialization.pbs.executers.ispaceproxy.SpaceProxyWrapper;
import java.rmi.RemoteException;
import net.jini.core.entry.UnusableEntryException;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.TransactionException;

public class ReadMultiple
extends AbstractPbsExecuter {
    public ReadMultiple(AbstractPbsExecutersBundle<?> bundle) {
        super(bundle, "ReadById");
    }

    @Override
    public void execute(PbsInputStream input, PbsOutputStream output, long handleId) throws RemoteException, TransactionException, UnusableEntryException {
        ISpaceProxy spaceProxy = ((SpaceProxyWrapper)PbsExecuter.ISpaceProxyBundle.getInstance(handleId)).getProxy();
        ITemplatePacket template = PbsEntryFormatter.readPbsTemplate((PbsInputStream)input, (ISpaceProxy)spaceProxy);
        Transaction txn = (Transaction)PbsExecuter.TransactionBundle.readInstance(input);
        int limit = input.readInt();
        int modifiers = input.readInt();
        try {
            Object[] results = spaceProxy.readMultiple((Object)template, txn, limit, modifiers);
            output.writeBoolean(true);
            PbsEntryFormatter.writePbsEntryPacketObjectArray((PbsOutputStream)output, (Object[])results);
        }
        catch (ReadMultipleException e) {
            output.writeBoolean(false);
            output.writeString(e.getMessage());
            Object[] results = e.getResults();
            Throwable[] causes = e.getCauses();
            PbsEntryFormatter.writePbsEntryPacketObjectArray((PbsOutputStream)output, (Object[])results);
            if (causes == null) {
                output.writeInt(-1);
            }
            output.writeInt(causes.length);
            for (int i = 0; i < causes.length; ++i) {
                PbsExceptionFormatter.writeException(output, causes[i], (short)1, false);
            }
        }
    }
}

