/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.serialization.pbs.executers.ispaceproxy;

import com.gigaspaces.cluster.activeelection.ISpaceModeListener;
import com.gigaspaces.cluster.activeelection.SpaceMode;
import com.gigaspaces.serialization.pbs.PbsInputStream;
import com.gigaspaces.serialization.pbs.PbsOutputStream;
import com.gigaspaces.serialization.pbs.commands.DispatcherObjectProxy;
import com.gigaspaces.serialization.pbs.commands.spacemodeeventscallbacks.SpaceModeChange;
import com.gigaspaces.serialization.pbs.executers.AbstractPbsExecuter;
import com.gigaspaces.serialization.pbs.executers.AbstractPbsExecutersBundle;
import com.gigaspaces.serialization.pbs.executers.PbsExecuter;
import com.gigaspaces.serialization.pbs.executers.ispaceproxy.SpaceProxyWrapper;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.IStubHandler;
import com.j_spaces.core.NoSuchNameException;
import com.j_spaces.core.admin.IInternalRemoteJSpaceAdmin;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.logging.Level;

public class RegisterToSpaceModeEvents
extends AbstractPbsExecuter {
    public RegisterToSpaceModeEvents(AbstractPbsExecutersBundle<?> bundle) {
        super(bundle, "RegisterToSpaceModeEvents");
    }

    @Override
    public void execute(PbsInputStream input, PbsOutputStream output, long handleId) throws RemoteException, NoSuchNameException {
        SpaceProxyWrapper proxyContainer = (SpaceProxyWrapper)PbsExecuter.ISpaceProxyBundle.getInstance(handleId);
        long callbackSpaceModeEventsHandleId = input.readLong();
        int contextAppDomainId = input.readInt();
        DispatcherCallbackSpaceModeListener listener = new DispatcherCallbackSpaceModeListener(callbackSpaceModeEventsHandleId, contextAppDomainId);
        IJSpace directProxy = proxyContainer.getProxy().getDirectProxy().getNonClusteredProxy();
        IStubHandler stubHandler = directProxy.getDirectProxy().getStubHandler();
        ISpaceModeListener remoteListener = (ISpaceModeListener)stubHandler.exportObject((Remote)((Object)listener));
        SpaceMode mode = ((IInternalRemoteJSpaceAdmin)directProxy.getAdmin()).addSpaceModeListener(remoteListener);
        proxyContainer.setListener(listener, remoteListener, stubHandler);
        output.writeString(mode.toString().toUpperCase());
    }

    private static class DispatcherCallbackSpaceModeListener
    extends DispatcherObjectProxy
    implements ISpaceModeListener {
        public DispatcherCallbackSpaceModeListener(long returnHandleId, int contextAppDomainId) {
            super((byte)4, returnHandleId, contextAppDomainId);
        }

        public void afterSpaceModeChange(SpaceMode newMode) throws RemoteException {
            try {
                boolean callbackActive = SpaceModeChange.execute(this, false, newMode);
                if (!callbackActive && _logger.isLoggable(Level.FINEST)) {
                    _logger.log(Level.FINEST, "Callback of SpaceModeChangedEvents notification is inactive, handle id: " + this.getHandleId());
                }
            }
            catch (Exception e) {
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.log(Level.FINEST, "Callback of SpaceModeEventsListener failed, handle id: " + this.getHandleId() + " - " + e);
                }
                throw new RemoteException("Error while dispatching space mode event", e);
            }
        }

        public void beforeSpaceModeChange(SpaceMode newMode) throws RemoteException {
            try {
                boolean callbackActive = SpaceModeChange.execute(this, true, newMode);
                if (!callbackActive && _logger.isLoggable(Level.FINEST)) {
                    _logger.log(Level.FINEST, "Callback of SpaceModeChangedEvents notification is inactive, handle id: " + this.getHandleId());
                }
            }
            catch (Exception e) {
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.log(Level.FINEST, "Callback of SpaceModeEventsListener failed, handle id: " + this.getHandleId() + " - " + e);
                }
                throw new RemoteException("Error while dispatching space mode event", e);
            }
        }
    }
}

