/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.serialization.pbs.executers.ispaceproxy;

import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.serialization.pbs.PbsInputStream;
import com.gigaspaces.serialization.pbs.PbsOutputStream;
import com.gigaspaces.serialization.pbs.executers.AbstractPbsExecuter;
import com.gigaspaces.serialization.pbs.executers.AbstractPbsExecutersBundle;
import com.gigaspaces.serialization.pbs.executers.PbsExecuter;
import com.gigaspaces.serialization.pbs.executers.ispaceproxy.SpaceProxyWrapper;
import com.j_spaces.core.exception.internal.PBSInternalSpaceException;

public class SetProperties
extends AbstractPbsExecuter {
    private static final byte Fifo = 0;
    private static final byte OptimisticLocking = 2;
    private static final byte ReadModifiers = 3;
    private static final byte UpdateModifiers = 4;

    public SetProperties(AbstractPbsExecutersBundle<?> bundle) {
        super(bundle, "SetProperties");
    }

    @Override
    public void execute(PbsInputStream input, PbsOutputStream output, long handleId) {
        ISpaceProxy spaceHandle = ((SpaceProxyWrapper)PbsExecuter.ISpaceProxyBundle.getInstance(handleId)).getProxy();
        byte property = input.readByte();
        switch (property) {
            case 0: {
                boolean fifo = input.readBoolean();
                spaceHandle.setFifo(fifo);
                break;
            }
            case 2: {
                boolean optimisticLocking = input.readBoolean();
                spaceHandle.setOptimisticLocking(optimisticLocking);
                break;
            }
            case 3: {
                int readModifiers = input.readInt();
                spaceHandle.setReadModifiers(readModifiers);
                break;
            }
            case 4: {
                int updateModifiers = input.readInt();
                spaceHandle.setUpdateModifiers(updateModifiers);
                break;
            }
            default: {
                throw new PBSInternalSpaceException("Unknown property code " + property + " in set properties command");
            }
        }
    }
}

