/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.serialization.pbs.executers.ispaceproxy;

import com.gigaspaces.client.ReadTakeByIdResult;
import com.gigaspaces.client.TakeByIdsException;
import com.gigaspaces.internal.client.QueryResultTypeInternal;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.client.spaceproxy.actioninfo.ReadTakeByIdsProxyActionInfo;
import com.gigaspaces.internal.transport.AbstractProjectionTemplate;
import com.gigaspaces.internal.transport.PbsEntryPacket;
import com.gigaspaces.internal.transport.PbsProjectionTemplate;
import com.gigaspaces.serialization.pbs.PbsEntryFormatter;
import com.gigaspaces.serialization.pbs.PbsExceptionFormatter;
import com.gigaspaces.serialization.pbs.PbsInputStream;
import com.gigaspaces.serialization.pbs.PbsOutputStream;
import com.gigaspaces.serialization.pbs.executers.AbstractPbsExecuter;
import com.gigaspaces.serialization.pbs.executers.AbstractPbsExecutersBundle;
import com.gigaspaces.serialization.pbs.executers.PbsExecuter;
import com.gigaspaces.serialization.pbs.executers.ispaceproxy.SpaceProxyWrapper;
import net.jini.core.transaction.Transaction;

public class TakeByIds
extends AbstractPbsExecuter {
    public TakeByIds(AbstractPbsExecutersBundle<?> bundle) {
        super(bundle, "TakeByIds");
    }

    @Override
    public void execute(PbsInputStream input, PbsOutputStream output, long handleId) throws Exception {
        ISpaceProxy spaceProxy = ((SpaceProxyWrapper)PbsExecuter.ISpaceProxyBundle.getInstance(handleId)).getProxy();
        String className = input.readString();
        boolean singleRouting = input.readBoolean();
        int length = input.readInt();
        Object[] ids = new Object[length];
        Object[] routings = singleRouting ? null : new Object[length];
        Object routing = null;
        for (int i = 0; i < length; ++i) {
            ids[i] = PbsEntryFormatter.readFieldValue((PbsInputStream)input, (ISpaceProxy)spaceProxy);
            if (singleRouting) continue;
            routings[i] = PbsEntryFormatter.readFieldValue((PbsInputStream)input, (ISpaceProxy)spaceProxy);
        }
        if (singleRouting) {
            routing = PbsEntryFormatter.readFieldValue((PbsInputStream)input, (ISpaceProxy)spaceProxy);
        }
        Transaction txn = (Transaction)PbsExecuter.TransactionBundle.readInstance(input);
        int modifiers = input.readInt();
        QueryResultTypeInternal queryResultType = PbsEntryFormatter.readQueryResultType((PbsInputStream)input);
        PbsProjectionTemplate projectionTemplate = PbsEntryFormatter.readProjectionTemplate((PbsInputStream)input);
        try {
            Object[] results = null;
            if (singleRouting) {
                ReadTakeByIdsProxyActionInfo actionInfo = new ReadTakeByIdsProxyActionInfo(spaceProxy, className, ids, routing, null, txn, true, modifiers, queryResultType, null, (AbstractProjectionTemplate)projectionTemplate);
                results = spaceProxy.takeByIds(actionInfo, true);
            } else {
                ReadTakeByIdsProxyActionInfo actionInfo = new ReadTakeByIdsProxyActionInfo(spaceProxy, className, ids, null, routings, txn, true, modifiers, queryResultType, null, (AbstractProjectionTemplate)projectionTemplate);
                results = spaceProxy.takeByIds(actionInfo, true);
            }
            output.writeBoolean(true);
            PbsEntryFormatter.writeNullablePbsEntryPacketObjectArray((PbsOutputStream)output, (Object[])results);
        }
        catch (TakeByIdsException e) {
            output.writeBoolean(false);
            output.writeString(e.getMessage());
            ReadTakeByIdResult[] results = e.getResults();
            if (results == null) {
                output.writeInt(-1);
            }
            output.writeInt(results.length);
            for (int i = 0; i < results.length; ++i) {
                this.writeExceptionResult(output, results[i]);
            }
        }
    }

    private void writeExceptionResult(PbsOutputStream output, ReadTakeByIdResult result) {
        boolean objectCode = false;
        boolean errorCode = true;
        if (result == null) {
            output.writeBoolean(false);
        } else {
            output.writeBoolean(true);
            PbsEntryFormatter.writeFieldValue((PbsOutputStream)output, (Object)result.getId());
            boolean isError = result.isError();
            if (isError) {
                output.writeByte((byte)1);
                if (result.getError() != null) {
                    output.writeBoolean(true);
                    PbsExceptionFormatter.writeException(output, result.getError(), (short)1, false);
                } else {
                    output.writeBoolean(false);
                }
            } else {
                output.writeByte((byte)0);
                PbsEntryFormatter.writeNullablePbsEntryPacket((PbsOutputStream)output, (PbsEntryPacket)((PbsEntryPacket)result.getObject()));
            }
        }
    }
}

