/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.serialization.pbs.executers.ispaceproxy;

import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.transport.PbsEntryPacket;
import com.gigaspaces.serialization.pbs.PbsEntryFormatter;
import com.gigaspaces.serialization.pbs.PbsExceptionFormatter;
import com.gigaspaces.serialization.pbs.PbsInputStream;
import com.gigaspaces.serialization.pbs.PbsOutputStream;
import com.gigaspaces.serialization.pbs.executers.AbstractPbsExecuter;
import com.gigaspaces.serialization.pbs.executers.AbstractPbsExecutersBundle;
import com.gigaspaces.serialization.pbs.executers.PbsExecuter;
import com.gigaspaces.serialization.pbs.executers.ispaceproxy.SpaceProxyWrapper;
import java.rmi.RemoteException;
import net.jini.core.entry.UnusableEntryException;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.TransactionException;

public class UpdateMultiple
extends AbstractPbsExecuter {
    private static final byte NULL_RESULT = 0;
    private static final byte EXCEPTION_RESULT = 1;
    private static final byte OBJECT_RESULT = 2;

    public UpdateMultiple(AbstractPbsExecutersBundle<?> bundle) {
        super(bundle, "UpdateMultiple");
    }

    @Override
    public void execute(PbsInputStream input, PbsOutputStream output, long handleId) throws RemoteException, UnusableEntryException, TransactionException {
        ISpaceProxy spaceProxy = ((SpaceProxyWrapper)PbsExecuter.ISpaceProxyBundle.getInstance(handleId)).getProxy();
        Transaction transaction = (Transaction)PbsExecuter.TransactionBundle.readInstance(input);
        int modifiers = input.readInt();
        int numberOfObjects = input.readInt();
        Object[] objects = new PbsEntryPacket[numberOfObjects];
        long[] leaseTimes = new long[numberOfObjects];
        boolean[] sendBackUids = new boolean[numberOfObjects];
        for (int i = 0; i < numberOfObjects; ++i) {
            objects[i] = PbsEntryFormatter.readPbsEntryPacket((PbsInputStream)input);
            leaseTimes[i] = input.readLong();
            sendBackUids[i] = input.readBoolean();
        }
        Object[] results = spaceProxy.updateMultiple(objects, transaction, leaseTimes, modifiers);
        if (results != null) {
            output.writeBoolean(true);
            for (int i = 0; i < numberOfObjects; ++i) {
                if (results[i] == null) {
                    output.writeByte((byte)0);
                    if (sendBackUids[i]) {
                        output.writeString(objects[i].getUID());
                    }
                } else if (results[i] instanceof Throwable) {
                    output.writeByte((byte)1);
                    PbsExceptionFormatter.writeException(output, (Throwable)results[i], (short)1, false);
                } else {
                    output.writeByte((byte)2);
                    PbsEntryPacket pbsPacket = (PbsEntryPacket)results[i];
                    PbsEntryFormatter.writePbsEntryPacket((PbsOutputStream)output, (PbsEntryPacket)pbsPacket);
                }
                output.writeInt(objects[i].getVersion());
            }
        } else {
            output.writeBoolean(false);
        }
    }
}

