/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.serialization.pbs.executers.ispaceproxy;

import com.gigaspaces.client.WriteMultipleException;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.serialization.pbs.PbsEntryFormatter;
import com.gigaspaces.serialization.pbs.PbsExceptionFormatter;
import com.gigaspaces.serialization.pbs.PbsInputStream;
import com.gigaspaces.serialization.pbs.PbsOutputStream;
import com.gigaspaces.serialization.pbs.executers.AbstractPbsExecuter;
import com.gigaspaces.serialization.pbs.executers.AbstractPbsExecutersBundle;
import com.gigaspaces.serialization.pbs.executers.PbsExecuter;
import com.gigaspaces.serialization.pbs.executers.ispaceproxy.SpaceProxyWrapper;
import com.gigaspaces.serialization.pbs.executers.lease.LeaseBundle;
import com.j_spaces.core.LeaseContext;
import com.j_spaces.core.exception.internal.PBSInternalSpaceException;
import com.j_spaces.core.multiple.write.IWriteResult;
import java.rmi.RemoteException;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.TransactionException;

public class WriteMultiple
extends AbstractPbsExecuter {
    public WriteMultiple(AbstractPbsExecutersBundle<?> bundle) {
        super(bundle, "WriteMultiple");
    }

    @Override
    public void execute(PbsInputStream input, PbsOutputStream output, long handleId) throws RemoteException, TransactionException {
        ISpaceProxy spaceProxy = ((SpaceProxyWrapper)PbsExecuter.ISpaceProxyBundle.getInstance(handleId)).getProxy();
        Object[] objects = PbsEntryFormatter.readPbsEntryPacketArray((PbsInputStream)input);
        Transaction txn = (Transaction)PbsExecuter.TransactionBundle.readInstance(input);
        long lease = Long.MIN_VALUE;
        long[] leases = null;
        long timeout = 0L;
        boolean multiLeases = input.readBoolean();
        if (multiLeases) {
            leases = input.readLongArray();
        } else {
            lease = input.readLong();
        }
        int modifiers = input.readInt();
        try {
            LeaseContext[] leaseContexts = spaceProxy.writeMultiple(objects, txn, lease, leases, timeout, modifiers);
            output.writeBoolean(true);
            if (leaseContexts == null) {
                output.writeInt(-1);
            } else {
                output.writeInt(leaseContexts.length);
                for (int i = 0; i < objects.length; ++i) {
                    LeaseBundle.serializeLeaseContext(output, leaseContexts[i], (IEntryPacket)objects[i]);
                }
            }
        }
        catch (WriteMultipleException e) {
            output.writeBoolean(false);
            output.writeString(e.getMessage());
            WriteMultiple.writeException(output, e.getResults(), (IEntryPacket[])objects);
        }
    }

    private static void writeException(PbsOutputStream output, WriteMultipleException.IWriteResult[] results, IEntryPacket[] entries) {
        boolean CODE_NONE = false;
        boolean CODE_LEASE = true;
        int CODE_ERROR = 2;
        if (results == null) {
            output.writeInt(-1);
        } else {
            output.writeInt(results.length);
            for (int i = 0; i < results.length; ++i) {
                WriteMultipleException.IWriteResult result = results[i];
                if (result == null) {
                    output.writeByte((byte)0);
                    continue;
                }
                IWriteResult.ResultType resultType = result.getResultType();
                if (resultType == IWriteResult.ResultType.LEASE) {
                    output.writeByte((byte)1);
                    LeaseBundle.serializeLeaseContext(output, result.getLeaseContext(), entries[i]);
                    continue;
                }
                if (resultType == IWriteResult.ResultType.ERROR) {
                    output.writeByte((byte)2);
                    if (result.getError() == null) {
                        output.writeBoolean(false);
                        continue;
                    }
                    output.writeBoolean(true);
                    PbsExceptionFormatter.writeException(output, result.getError(), (short)1, false);
                    continue;
                }
                throw new PBSInternalSpaceException("Unknown result in WriteMultiplePartialFailureException, result = " + resultType);
            }
        }
    }
}

