/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.serialization.pbs.executers.lease;

import com.gigaspaces.internal.metadata.SpaceIdType;
import com.gigaspaces.internal.remoting.routing.partitioned.PartitionedClusterUtils;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.transport.PbsEntryPacket;
import com.gigaspaces.serialization.pbs.PbsEntryFormatter;
import com.gigaspaces.serialization.pbs.PbsOutputStream;
import com.gigaspaces.serialization.pbs.executers.AbstractPbsExecuter;
import com.gigaspaces.serialization.pbs.executers.AbstractPbsExecutersBundle;
import com.gigaspaces.serialization.pbs.executers.lease.Cancel;
import com.gigaspaces.serialization.pbs.executers.lease.GetExpiration;
import com.gigaspaces.serialization.pbs.executers.lease.Renew;
import com.j_spaces.core.LeaseContext;
import net.jini.core.lease.Lease;

public class LeaseBundle
extends AbstractPbsExecutersBundle<Lease> {
    public LeaseBundle(byte bundleCode) {
        super(bundleCode, "Lease");
    }

    @Override
    protected AbstractPbsExecuter[] initExecuters() {
        AbstractPbsExecuter[] executers = new AbstractPbsExecuter[4];
        executers[1] = new Cancel(this);
        executers[2] = new Renew(this);
        executers[3] = new GetExpiration(this);
        return executers;
    }

    public static void serializeLeaseContext(PbsOutputStream output, LeaseContext<?> lease, IEntryPacket entryPacket) {
        String uid = lease.getVersion() > 1 || entryPacket.getTypeDescriptor().getSpaceIdType() == SpaceIdType.MANUAL ? null : lease.getUID();
        output.writeString(uid);
        Object routing = entryPacket.getRoutingFieldValue();
        output.writeInt(routing == null ? 0 : PartitionedClusterUtils.safeAbs((int)routing.hashCode()));
        output.writeLong(lease.getExpiration());
        output.writeInt(lease.getVersion());
        Object previousObject = lease.getObject();
        if (previousObject == null) {
            output.writeBoolean(false);
        } else {
            output.writeBoolean(true);
            PbsEntryFormatter.writePbsEntryPacketLazy((PbsOutputStream)output, (PbsEntryPacket)((PbsEntryPacket)previousObject));
        }
    }

    public void serializeLeaseContextOld(PbsOutputStream output, LeaseContext<?> leaseContext, long leaseHandleId, boolean isDisabledLease) {
        PbsEntryPacket previousObject;
        if (!isDisabledLease) {
            output.writeLong(leaseHandleId);
        }
        if ((previousObject = (PbsEntryPacket)leaseContext.getObject()) != null) {
            output.writeBoolean(true);
            PbsEntryFormatter.writePbsEntryPacketLazy((PbsOutputStream)output, (PbsEntryPacket)previousObject);
        } else {
            output.writeBoolean(false);
        }
    }

    public void addAndSerializeLeaseContextOld(PbsOutputStream output, LeaseContext<?> leaseContext) {
        long leaseHandleId = this.addInstance(leaseContext);
        this.serializeLeaseContextOld(output, leaseContext, leaseHandleId, false);
    }

    public void addAndSerializeLease(PbsOutputStream output, Lease lease) {
        long leaseHandleId = this.addInstance(lease);
        output.writeLong(leaseHandleId);
    }
}

