/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.serialization.pbs.executers.staticbundle;

import com.gigaspaces.serialization.pbs.PbsInputStream;
import com.gigaspaces.serialization.pbs.PbsOutputStream;
import com.gigaspaces.serialization.pbs.executers.AbstractPbsExecuter;
import com.gigaspaces.serialization.pbs.executers.AbstractPbsExecutersBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Log
extends AbstractPbsExecuter {
    private static final byte VERBOSE_CODE = 0;
    private static final byte INFORMATION_CODE = 1;
    private static final byte WARNING_CODE = 2;
    private static final byte ERROR_CODE = 3;

    public Log(AbstractPbsExecutersBundle<?> bundle) {
        super(bundle, "Log");
    }

    @Override
    public void execute(PbsInputStream input, PbsOutputStream output, long handleId) {
        String loggerName = input.readString();
        String message = input.readString();
        byte levelCode = input.readByte();
        Level loggingLevel = Level.FINEST;
        switch (levelCode) {
            case 0: {
                loggingLevel = Level.FINEST;
                break;
            }
            case 1: {
                loggingLevel = Level.INFO;
                break;
            }
            case 2: {
                loggingLevel = Level.WARNING;
                break;
            }
            case 3: {
                loggingLevel = Level.SEVERE;
                break;
            }
            default: {
                loggingLevel = Level.FINEST;
            }
        }
        Logger logger = Logger.getLogger(loggerName);
        if (logger.isLoggable(loggingLevel)) {
            logger.log(loggingLevel, message);
        }
    }
}

