/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.serialization.pbs.openspaces;

import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.serialization.pbs.commands.ConstructableDispatcherObjectProxy;
import com.gigaspaces.serialization.pbs.commands.processingunit.Init;
import com.gigaspaces.serialization.pbs.commands.processingunit.Monitor;
import com.gigaspaces.serialization.pbs.commands.processingunit.PUDetailsHolder;
import com.gigaspaces.serialization.pbs.commands.processingunit.ServicesMonitors;
import com.gigaspaces.serialization.pbs.executers.PbsExecuter;
import com.gigaspaces.serialization.pbs.executers.ispaceproxy.SpaceProxyWrapper;
import com.j_spaces.core.IJSpace;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import net.jini.id.Uuid;

public class ProcessingUnitProxy
extends ConstructableDispatcherObjectProxy {
    private UUID contextIdentifier;
    private PUDetailsHolder puDetails;

    public ProcessingUnitProxy(String assemblyFullPath, String implementationName, String[] dependencies, String deploymentDirectory, Properties customProperties, Integer backupId, Integer instanceId, Integer numberOfBackups, Integer numberOfInstances, String schema, String name, UUID contextIdentifier) {
        super((byte)1);
        this.contextIdentifier = contextIdentifier;
        this.puDetails = Init.execute(this, assemblyFullPath, implementationName, dependencies, deploymentDirectory, customProperties, backupId, instanceId, numberOfBackups, numberOfInstances, schema, name, contextIdentifier);
        this.setHandleId(this.puDetails.getHandleId());
    }

    public ProcessingUnitProxy(String assemblyFullPath, String implementationName, String[] dependencies, String deploymentDirectory, Properties customProperties, UUID contextIdentifier) {
        super((byte)1);
        this.contextIdentifier = contextIdentifier;
        this.puDetails = Init.execute(this, assemblyFullPath, implementationName, dependencies, deploymentDirectory, customProperties, contextIdentifier);
        this.setHandleId(this.puDetails.getHandleId());
    }

    public void close() {
        this.dispose();
    }

    public IJSpace[] getContextProxies() {
        HashMap<Uuid, ISpaceProxy> uniqueProxies = new HashMap<Uuid, ISpaceProxy>();
        ArrayList<ISpaceProxy> proxies = new ArrayList<ISpaceProxy>();
        Set proxyKeys = PbsExecuter.ISpaceProxyBundle.entrySet();
        for (Map.Entry entry : proxyKeys) {
            SpaceProxyWrapper proxyWrapper = (SpaceProxyWrapper)entry.getValue();
            if (!this.matchContext(proxyWrapper)) continue;
            ISpaceProxy currentProxy = proxyWrapper.getProxy();
            Uuid referentUuid = currentProxy.getReferentUuid();
            if (!uniqueProxies.containsKey(referentUuid)) {
                uniqueProxies.put(referentUuid, currentProxy);
                proxies.add(((SpaceProxyWrapper)entry.getValue()).getProxy());
                continue;
            }
            ISpaceProxy spaceProxy = (ISpaceProxy)uniqueProxies.get(referentUuid);
            if (!spaceProxy.isEmbedded() || !spaceProxy.isClustered() || !currentProxy.isEmbedded() || currentProxy.isClustered()) continue;
            uniqueProxies.put(referentUuid, currentProxy);
            proxies.remove(spaceProxy);
            proxies.add(currentProxy);
        }
        return proxies.toArray(new IJSpace[proxies.size()]);
    }

    public PUDetailsHolder getPUDetailsHolder() {
        return this.puDetails;
    }

    public ServicesMonitors getServicesMonitors() {
        return Monitor.execute(this);
    }

    private boolean matchContext(SpaceProxyWrapper proxyWrapper) {
        return this.contextIdentifier.equals(proxyWrapper.getProcessingUnitIdentifierContext());
    }
}

