/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin;

import com.gigaspaces.logger.GSLogConfigLoader;
import com.gigaspaces.security.directory.CredentialsProvider;
import com.gigaspaces.security.directory.DefaultCredentialsProvider;
import com.gigaspaces.security.directory.UserDetails;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jini.rio.boot.BootUtil;
import org.openspaces.admin.Admin;
import org.openspaces.admin.internal.admin.DefaultAdmin;
import org.openspaces.security.AdminFilter;

public class AdminFactory {
    private boolean useGsLogging = true;
    private final AtomicBoolean created = new AtomicBoolean(false);
    private boolean useDaemonThreads = false;
    private boolean singleThreadedEventListeners = false;
    private final List<String> groups = new ArrayList<String>();
    private final List<String> locators = new ArrayList<String>();
    private CredentialsProvider credentialsProvider = null;
    private boolean discoverUnmanagedSpaces = false;
    private AdminFilter adminFilter;
    private Class[] discoveryServices;

    public AdminFactory useGsLogging(boolean useGsLogging) {
        this.useGsLogging = useGsLogging;
        return this;
    }

    public AdminFactory useDaemonThreads(boolean useDaemonThreads) {
        this.useDaemonThreads = useDaemonThreads;
        return this;
    }

    public AdminFactory addGroup(String group) {
        this.groups.add(group);
        return this;
    }

    public AdminFactory addGroups(String groups) {
        String[] groupsArr;
        for (String group : groupsArr = BootUtil.toArray((String)groups)) {
            this.addGroup(group);
        }
        return this;
    }

    public AdminFactory addLocator(String locator) {
        this.locators.add(locator);
        return this;
    }

    public AdminFactory addLocators(String locators) {
        String[] locatorsArr;
        for (String locator : locatorsArr = BootUtil.toArray((String)locators)) {
            this.addLocator(locator);
        }
        return this;
    }

    @Deprecated
    public AdminFactory userDetails(String userName, String password) {
        return this.credentials(userName, password);
    }

    @Deprecated
    public AdminFactory userDetails(UserDetails userDetails) {
        return this.credentialsProvider((CredentialsProvider)new DefaultCredentialsProvider(userDetails));
    }

    public AdminFactory credentials(String userName, String password) {
        return this.credentialsProvider((CredentialsProvider)new DefaultCredentialsProvider(userName, password));
    }

    public AdminFactory credentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
        return this;
    }

    public AdminFactory adminFilter(AdminFilter adminFilter) {
        this.adminFilter = adminFilter;
        return this;
    }

    public void setDiscoveryServices(Class ... discoveryServices) {
        this.discoveryServices = discoveryServices;
    }

    public AdminFactory discoverUnmanagedSpaces() {
        this.discoverUnmanagedSpaces = true;
        return this;
    }

    protected AdminFactory singleThreadedEventListeners() {
        this.singleThreadedEventListeners = true;
        return this;
    }

    public Admin create() {
        if (!this.created.compareAndSet(false, true)) {
            throw new IllegalStateException("AdminFactory#create() has already been called.");
        }
        if (this.useGsLogging) {
            GSLogConfigLoader.getLoader();
        }
        DefaultAdmin admin = new DefaultAdmin(this.useDaemonThreads, this.singleThreadedEventListeners);
        admin.setCredentialsProvider(this.credentialsProvider);
        admin.setAdminFilter(this.adminFilter);
        admin.setDiscoveryServices(this.discoveryServices);
        for (String group : this.groups) {
            admin.addGroup(group);
        }
        for (String locator : this.locators) {
            admin.addLocator(locator);
        }
        if (this.discoverUnmanagedSpaces) {
            admin.getDiscoveryService().discoverUnmanagedSpaces();
        }
        admin.begin();
        return admin;
    }

    public Admin createAdmin() {
        return this.create();
    }
}

