/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.alert;

import java.util.HashMap;
import java.util.Map;
import org.openspaces.admin.AdminException;
import org.openspaces.admin.alert.Alert;
import org.openspaces.admin.alert.AlertSeverity;
import org.openspaces.admin.alert.AlertStatus;
import org.openspaces.admin.internal.alert.DefaultAlert;

public class AlertFactory {
    private final DefaultAlert alert = new DefaultAlert();

    public AlertFactory() {
        this.alert.setTimestamp(System.currentTimeMillis());
    }

    public AlertFactory(String groupUid, AlertSeverity alertSeverity, AlertStatus alertStatus) {
        this();
        this.groupUid(groupUid);
        this.severity(alertSeverity);
        this.status(alertStatus);
    }

    public AlertFactory name(String name) {
        this.alert.setName(name);
        return this;
    }

    public AlertFactory description(String description) {
        this.alert.setDescription(description);
        return this;
    }

    public AlertFactory timestamp(long timestamp) {
        this.alert.setTimestamp(timestamp);
        return this;
    }

    public AlertFactory severity(AlertSeverity severity) {
        this.alert.setSeverity(severity);
        return this;
    }

    public AlertFactory status(AlertStatus status) {
        this.alert.setStatus(status);
        return this;
    }

    public AlertFactory groupUid(String groupUid) {
        this.alert.setGroupUid(groupUid);
        return this;
    }

    public AlertFactory componentUid(String componentUid) {
        this.alert.setComponentUid(componentUid);
        return this;
    }

    public AlertFactory componentDescription(String componentDescription) {
        this.alert.setComponentDescription(componentDescription);
        return this;
    }

    public AlertFactory config(Map<String, String> properties) {
        HashMap<String, String> configProperties = new HashMap<String, String>(properties);
        this.alert.setConfig(configProperties);
        return this;
    }

    public AlertFactory properties(Map<String, String> properties) {
        HashMap<String, String> newProperties = new HashMap<String, String>(properties);
        this.alert.setProperties(newProperties);
        return this;
    }

    public AlertFactory putProperties(Map<String, String> properties) {
        if (this.alert.getProperties() == null) {
            this.properties(properties);
        } else {
            this.alert.getProperties().putAll(properties);
        }
        return this;
    }

    public AlertFactory putProperty(String key, String value) {
        if (this.alert.getProperties() == null) {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put(key, value);
            this.alert.setProperties(properties);
        } else {
            this.alert.getProperties().put(key, value);
        }
        return this;
    }

    public Alert toAlert() {
        return this.create();
    }

    public Alert create() {
        if (this.alert.getGroupUid() == null) {
            throw new AdminException("Alert should be configured with a unique group id");
        }
        if (this.alert.getSeverity() == null) {
            throw new AdminException("Alert should be configured with a severity level");
        }
        if (this.alert.getStatus() == null) {
            throw new AdminException("Alert should be configured with an status level");
        }
        if (this.alert.getConfig() == null) {
            this.alert.setConfig(new HashMap<String, String>(0));
        }
        if (this.alert.getProperties() == null) {
            this.alert.setProperties(new HashMap<String, String>(0));
        }
        return this.alert;
    }
}

