/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.alert;

import java.io.Serializable;

public class AlertSeverity
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final int value;
    public static final AlertSeverity SEVERE = new AlertSeverity("SEVERE", 1000);
    public static final AlertSeverity WARNING = new AlertSeverity("WARNING", 900);
    public static final AlertSeverity INFO = new AlertSeverity("INFO", 800);

    protected AlertSeverity(String name, int value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }

    public boolean isSevere() {
        return this == SEVERE;
    }

    public boolean isWarning() {
        return this == WARNING;
    }

    public boolean isInfo() {
        return this == INFO;
    }

    public static AlertSeverity parse(String name) {
        if (AlertSeverity.SEVERE.name.equals(name)) {
            return SEVERE;
        }
        if (AlertSeverity.WARNING.name.equals(name)) {
            return WARNING;
        }
        if (AlertSeverity.INFO.name.equals(name)) {
            return INFO;
        }
        throw new IllegalArgumentException("Could not match an AlertSeverity with a name of " + name);
    }

    public static AlertSeverity parse(int value) {
        if (value == AlertSeverity.SEVERE.value) {
            return SEVERE;
        }
        if (value == AlertSeverity.WARNING.value) {
            return WARNING;
        }
        if (value == AlertSeverity.INFO.value) {
            return INFO;
        }
        throw new IllegalArgumentException("Could not match an AlertSeverity with a value of " + value);
    }

    public boolean equals(Object obj) {
        try {
            AlertSeverity s = (AlertSeverity)obj;
            return s.value == this.value;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public int hashCode() {
        return this.value;
    }

    public final String toString() {
        return this.name;
    }
}

