/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.alert;

import java.io.Serializable;

public class AlertStatus
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final int value;
    public static final AlertStatus ESCALATED = new AlertStatus("ESCALATED", 1000);
    public static final AlertStatus RAISED = new AlertStatus("RAISED", 900);
    public static final AlertStatus SUPPRESSED = new AlertStatus("SUPPRESSED", 800);
    public static final AlertStatus RESOLVED = new AlertStatus("RESOLVED", 700);
    public static final AlertStatus NA = new AlertStatus("NA", 600);

    protected AlertStatus(String name, int value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }

    public boolean isEscalated() {
        return this == ESCALATED;
    }

    public boolean isRaised() {
        return this == RAISED;
    }

    public boolean isSuppressed() {
        return this == SUPPRESSED;
    }

    public boolean isResolved() {
        return this == RESOLVED;
    }

    public boolean isUnresolved() {
        return this.value > RESOLVED.getValue();
    }

    public boolean isNotAvailable() {
        return this == NA;
    }

    public static AlertStatus parse(String name) {
        if (AlertStatus.ESCALATED.name.equals(name)) {
            return ESCALATED;
        }
        if (AlertStatus.RAISED.name.equals(name)) {
            return RAISED;
        }
        if (AlertStatus.SUPPRESSED.name.equals(name)) {
            return SUPPRESSED;
        }
        if (AlertStatus.RESOLVED.name.equals(name)) {
            return RESOLVED;
        }
        if (AlertStatus.NA.name.equals(name)) {
            return NA;
        }
        throw new IllegalArgumentException("Could not match an AlertStatus with a name of " + name);
    }

    public static AlertStatus parse(int value) {
        if (value == AlertStatus.ESCALATED.value) {
            return ESCALATED;
        }
        if (value == AlertStatus.RAISED.value) {
            return RAISED;
        }
        if (value == AlertStatus.SUPPRESSED.value) {
            return SUPPRESSED;
        }
        if (value == AlertStatus.RESOLVED.value) {
            return RESOLVED;
        }
        if (value == AlertStatus.NA.value) {
            return NA;
        }
        throw new IllegalArgumentException("Could not match an AlertStatus with a value of " + value);
    }

    public boolean equals(Object obj) {
        try {
            AlertStatus s = (AlertStatus)obj;
            return s.value == this.value;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public int hashCode() {
        return this.value;
    }

    public final String toString() {
        return this.name;
    }
}

