/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.alert.alerts;

import org.openspaces.admin.alert.Alert;
import org.openspaces.admin.alert.alerts.AbstractAlert;

public class HeapMemoryUtilizationAlert
extends AbstractAlert {
    private static final long serialVersionUID = 1L;
    public static final String HOST_ADDRESS = "host-address";
    public static final String HOST_NAME = "host-name";
    public static final String CPU_UTILIZATION = "cpu-utilization";
    public static final String PROCESS_ID = "process-id";
    public static final String COMPONENT_NAME = "component-name";
    public static final String HEAP_UTILIZATION = "heap-utilization";
    public static final String MAX_HEAP_IN_BYTES = "max-heap-in-bytes";

    public HeapMemoryUtilizationAlert() {
    }

    public HeapMemoryUtilizationAlert(Alert alert) {
        super(alert);
    }

    @Override
    public String getComponentUid() {
        return super.getComponentUid();
    }

    public String getHostAddress() {
        return this.getProperties().get(HOST_ADDRESS);
    }

    public String getHostName() {
        return this.getProperties().get(HOST_NAME);
    }

    public Double getCpuUtilization() {
        String value = this.getProperties().get(CPU_UTILIZATION);
        if (value == null) {
            return null;
        }
        return Double.valueOf(value);
    }

    public String getProcessId() {
        return this.getProperties().get(PROCESS_ID);
    }

    public String getComponentName() {
        return this.getProperties().get(COMPONENT_NAME);
    }

    public Double getHeapUtilization() {
        String value = this.getProperties().get(HEAP_UTILIZATION);
        if (value == null) {
            return null;
        }
        return Double.valueOf(value);
    }

    public Long getMaxHeapInBytes() {
        String value = this.getProperties().get(MAX_HEAP_IN_BYTES);
        if (value == null) {
            return null;
        }
        return Long.valueOf(value);
    }
}

