/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.alert.alerts;

import org.openspaces.admin.alert.Alert;
import org.openspaces.admin.alert.alerts.AbstractAlert;

public class ReplicationRedoLogOverflowToDiskAlert
extends AbstractAlert {
    private static final long serialVersionUID = 1L;
    public static final String HOST_ADDRESS = "host-address";
    public static final String HOST_NAME = "host-name";
    public static final String VIRTUAL_MACHINE_UID = "vm-uid";
    public static final String CPU_UTILIZATION = "cpu-utilization";
    public static final String HEAP_UTILIZATION = "heap-utilization";
    public static final String REPLICATION_STATUS = "replication-status";
    public static final String REDO_LOG_SIZE = "redo-log-size";
    public static final String REDO_LOG_MEMORY_SIZE = "redo-log-memory-size";
    public static final String REDO_LOG_SWAP_SIZE = "redo-log-swap-size";

    public ReplicationRedoLogOverflowToDiskAlert() {
    }

    public ReplicationRedoLogOverflowToDiskAlert(Alert alert) {
        super(alert);
    }

    @Override
    public String getComponentUid() {
        return super.getComponentUid();
    }

    public String getHostAddress() {
        return this.getProperties().get(HOST_ADDRESS);
    }

    public String getHostName() {
        return this.getProperties().get(HOST_NAME);
    }

    public String getVirtualMachineUid() {
        return this.getProperties().get(VIRTUAL_MACHINE_UID);
    }

    public Double getCpuUtilization() {
        String value = this.getProperties().get(CPU_UTILIZATION);
        if (value == null) {
            return null;
        }
        return Double.valueOf(value);
    }

    public Double getHeapUtilization() {
        String value = this.getProperties().get(HEAP_UTILIZATION);
        if (value == null) {
            return null;
        }
        return Double.valueOf(value);
    }

    public String getReplicationStatus() {
        return this.getProperties().get(REPLICATION_STATUS);
    }

    public Integer getRedoLogSize() {
        String value = this.getProperties().get(REDO_LOG_SIZE);
        if (value == null) {
            return null;
        }
        return Integer.valueOf(value);
    }

    public Integer getRedoLogMemorySize() {
        String value = this.getProperties().get(REDO_LOG_MEMORY_SIZE);
        if (value == null) {
            return null;
        }
        return Integer.valueOf(value);
    }

    public Integer getRedoLogSwapSize() {
        String value = this.getProperties().get(REDO_LOG_SWAP_SIZE);
        if (value == null) {
            return null;
        }
        return Integer.valueOf(value);
    }
}

