/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.alert.config;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.openspaces.admin.alert.config.AlertConfiguration;
import org.openspaces.admin.internal.alert.bean.GarbageCollectionAlertBean;

public class GarbageCollectionAlertConfiguration
implements AlertConfiguration {
    private static final long serialVersionUID = 1L;
    public static final String LONG_GC_PAUSE_PERIOD_MILLISECONDS_KEY = "long-gc-pause-period-milliseconds";
    public static final String SHORT_GC_PAUSE_PERIOD_MILLISECONDS_KEY = "short-gc-pause-period-milliseconds";
    private final Map<String, String> properties = new HashMap<String, String>();
    private boolean enabled;

    public void setLongGcPausePeriod(long period, TimeUnit timeUnit) {
        long periodInMilliseconds = timeUnit.toMillis(period);
        this.properties.put(LONG_GC_PAUSE_PERIOD_MILLISECONDS_KEY, String.valueOf(periodInMilliseconds));
    }

    public Long getLongGcPausePeriod() {
        String value = this.properties.get(LONG_GC_PAUSE_PERIOD_MILLISECONDS_KEY);
        if (value == null) {
            return null;
        }
        return Long.valueOf(value);
    }

    public void setShortGcPausePeriod(long period, TimeUnit timeUnit) {
        long periodInMilliseconds = timeUnit.toMillis(period);
        this.properties.put(SHORT_GC_PAUSE_PERIOD_MILLISECONDS_KEY, String.valueOf(periodInMilliseconds));
    }

    public Long getShortGcPausePeriod() {
        String value = this.properties.get(SHORT_GC_PAUSE_PERIOD_MILLISECONDS_KEY);
        if (value == null) {
            return null;
        }
        return Long.valueOf(value);
    }

    @Override
    public void setProperties(Map<String, String> properties) {
        this.properties.clear();
        this.properties.putAll(properties);
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public String getBeanClassName() {
        return GarbageCollectionAlertBean.class.getName();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

