/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.alert.config;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.openspaces.admin.alert.config.AlertConfiguration;
import org.openspaces.admin.internal.alert.bean.HeapMemoryUtilizationAlertBean;

public class HeapMemoryUtilizationAlertConfiguration
implements AlertConfiguration {
    private static final long serialVersionUID = 1L;
    public static final String MEASUREMENT_PERIOD_MILLISECONDS_KEY = "measurement-period-milliseconds";
    public static final String LOW_THRESHOLD_PERC_KEY = "low-threshold-perc";
    public static final String HIGH_THRESHOLD_PERC_KEY = "high-threshold-perc";
    private final Map<String, String> properties = new HashMap<String, String>();
    private boolean enabled;

    public void setHighThresholdPerc(int highThreshold) {
        this.properties.put(HIGH_THRESHOLD_PERC_KEY, String.valueOf(highThreshold));
    }

    public Integer getHighThresholdPerc() {
        String value = this.properties.get(HIGH_THRESHOLD_PERC_KEY);
        if (value == null) {
            return null;
        }
        return Integer.valueOf(value);
    }

    public void setLowThresholdPerc(int lowThreshold) {
        this.properties.put(LOW_THRESHOLD_PERC_KEY, String.valueOf(lowThreshold));
    }

    public Integer getLowThresholdPerc() {
        String value = this.properties.get(LOW_THRESHOLD_PERC_KEY);
        if (value == null) {
            return null;
        }
        return Integer.valueOf(value);
    }

    public void setMeasurementPeriod(long period, TimeUnit timeUnit) {
        long periodInMilliseconds = timeUnit.toMillis(period);
        this.properties.put(MEASUREMENT_PERIOD_MILLISECONDS_KEY, String.valueOf(periodInMilliseconds));
    }

    public Long getMeasurementPeriod() {
        String value = this.properties.get(MEASUREMENT_PERIOD_MILLISECONDS_KEY);
        if (value == null) {
            return null;
        }
        return Long.valueOf(value);
    }

    @Override
    public void setProperties(Map<String, String> properties) {
        this.properties.clear();
        this.properties.putAll(properties);
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public String getBeanClassName() {
        return HeapMemoryUtilizationAlertBean.class.getName();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

