/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.alert.config.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openspaces.admin.alert.config.AlertConfiguration;
import org.openspaces.admin.alert.config.parser.AlertConfigurationParser;
import org.openspaces.admin.alert.config.parser.AlertConfigurationParserException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlAlertConfigurationParser
implements AlertConfigurationParser {
    private static final Log logger = LogFactory.getLog(XmlAlertConfigurationParser.class);
    public static final String DEFAULT_ALERT_CONFIG_DIRECTORY = "config/alerts/";
    public static final String DEFAULT_ALERT_RESOURCE_NAME = "alerts.xml";
    private final InputStream is;

    public XmlAlertConfigurationParser() throws AlertConfigurationParserException {
        InputStream resourceAsStream;
        String resourceName = DEFAULT_ALERT_RESOURCE_NAME;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Trying to locate " + resourceName + " in classpath"));
        }
        if ((resourceAsStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceName)) == null) {
            String altResourceName = "config/alerts/alerts.xml";
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Failed to locate " + resourceName + ". Trying to locate " + altResourceName + " in classpath"));
            }
            resourceAsStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(altResourceName);
        }
        if (resourceAsStream == null) {
            throw new AlertConfigurationParserException("Could not locate default alerts configuration file [alerts.xml]");
        }
        this.is = resourceAsStream;
    }

    public XmlAlertConfigurationParser(String resourceName) throws AlertConfigurationParserException {
        File file;
        InputStream resourceAsStream = null;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Trying to load " + resourceName + " using direct file path"));
        }
        if ((file = new File(resourceName)).exists()) {
            try {
                resourceAsStream = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                throw new AlertConfigurationParserException("Failed to find file " + resourceName, e);
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Trying to locate " + resourceName + " in classpath"));
            }
            if ((resourceAsStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceName)) == null) {
                resourceName = DEFAULT_ALERT_CONFIG_DIRECTORY + resourceName;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Trying to locate " + resourceName + " in classpath"));
                }
                resourceAsStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceName);
            }
        }
        if (resourceAsStream == null) {
            throw new AlertConfigurationParserException("Could not locate alerts configuration file [" + resourceName + "]");
        }
        this.is = resourceAsStream;
    }

    @Override
    public AlertConfiguration[] parse() throws AlertConfigurationParserException {
        ArrayList<AlertConfiguration> alertConfigurations = new ArrayList<AlertConfiguration>();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            docBuilder.setErrorHandler(new SimpleSaxErrorHandler());
            Document doc = docBuilder.parse(new InputSource(this.is));
            Element alertsElm = doc.getDocumentElement();
            List<Element> list = XmlAlertConfigurationParser.getChildElementsByTagName(alertsElm, "alert");
            for (Element alertElm : list) {
                String classAttr = alertElm.getAttribute("class");
                String enabledAttr = alertElm.getAttribute("enabled");
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("alert: class=" + classAttr + " enabled=" + enabledAttr));
                    logger.trace((Object)"properties: ");
                }
                HashMap<String, String> properties = new HashMap<String, String>();
                List<Element> propertiesElm = XmlAlertConfigurationParser.getChildElementsByTagName(alertElm, "property");
                for (Element property : propertiesElm) {
                    String keyAttr = property.getAttribute("key");
                    String valueAttr = property.getAttribute("value");
                    properties.put(keyAttr, valueAttr);
                    if (!logger.isTraceEnabled()) continue;
                    logger.trace((Object)("property: key=" + keyAttr + " value=" + valueAttr));
                }
                Class<AlertConfiguration> clazz = Thread.currentThread().getContextClassLoader().loadClass(classAttr).asSubclass(AlertConfiguration.class);
                AlertConfiguration alertConfiguration = clazz.newInstance();
                alertConfiguration.setEnabled(Boolean.parseBoolean(enabledAttr));
                alertConfiguration.setProperties(properties);
                alertConfigurations.add(alertConfiguration);
            }
        }
        catch (Throwable t) {
            throw new AlertConfigurationParserException("Failed to parse configuration file", t);
        }
        finally {
            try {
                this.is.close();
            }
            catch (IOException factory) {}
        }
        return alertConfigurations.toArray(new AlertConfiguration[alertConfigurations.size()]);
    }

    private static List<Element> getChildElementsByTagName(Element ele, String childEleName) {
        NodeList nl = ele.getChildNodes();
        ArrayList<Element> childEles = new ArrayList<Element>();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            String name = node.getNodeName();
            if (!(node instanceof Element) || !childEleName.equals(name)) continue;
            childEles.add((Element)node);
        }
        return childEles;
    }

    private static class SimpleSaxErrorHandler
    implements ErrorHandler {
        private SimpleSaxErrorHandler() {
        }

        @Override
        public void warning(SAXParseException ex) throws SAXException {
            logger.warn((Object)("Ignored XML validation warning [" + ex.getMessage() + "]"), (Throwable)ex);
        }

        @Override
        public void error(SAXParseException ex) throws SAXException {
            throw ex;
        }

        @Override
        public void fatalError(SAXParseException ex) throws SAXException {
            throw ex;
        }
    }
}

