/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.application;

import org.openspaces.admin.application.config.ApplicationConfig;
import org.openspaces.admin.pu.topology.ProcessingUnitConfigHolder;
import org.openspaces.admin.pu.topology.ProcessingUnitDeploymentTopology;

public class ApplicationDeployment {
    private final ApplicationConfig config;

    public ApplicationDeployment(String applicationName) {
        this.config = new ApplicationConfig();
        this.config.setName(applicationName);
    }

    public ApplicationDeployment(String applicationName, ProcessingUnitDeploymentTopology ... processingUnitDeployments) {
        this(applicationName);
        for (ProcessingUnitDeploymentTopology puDeployment : processingUnitDeployments) {
            this.addProcessingUnitDeployment(puDeployment);
        }
    }

    public ApplicationDeployment(String applicationName, ProcessingUnitConfigHolder ... processingUnitConfigHolders) {
        this(applicationName);
        for (ProcessingUnitConfigHolder puConfigHolder : processingUnitConfigHolders) {
            this.addProcessingUnitDeployment(puConfigHolder);
        }
    }

    protected ApplicationDeployment(ApplicationConfig config) {
        this.config = config;
    }

    @Deprecated
    public ApplicationDeployment deployProcessingUnit(ProcessingUnitDeploymentTopology puDeployment) {
        return this.addProcessingUnitDeployment(puDeployment);
    }

    public ApplicationDeployment addProcessingUnitDeployment(ProcessingUnitDeploymentTopology puDeployment) {
        this.addProcessingUnitDeployment(puDeployment.create());
        return this;
    }

    public ApplicationDeployment addProcessingUnitDeployment(ProcessingUnitConfigHolder puConfigHolder) {
        this.config.addProcessingUnit(puConfigHolder);
        return this;
    }

    public ApplicationConfig create() {
        return this.config;
    }
}

