/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.application;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openspaces.admin.AdminException;
import org.openspaces.admin.application.config.ApplicationConfig;
import org.openspaces.core.util.FileUtils;
import org.openspaces.core.util.MemoryUnit;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;

public class ApplicationFileDeployment {
    private static final Log logger = LogFactory.getLog(ApplicationFileDeployment.class);
    private File applicationDirectoryOrZip;
    private String applicationFileName;
    private static final String DEFAULT_APPLICATION_XML_FILENAME = "application.xml";
    private static final long MAX_XML_FILE_SIZE = MemoryUnit.toBytes((String)System.getProperty("org.openspaces.admin.application.max-xml-file-size", "10m"));

    public ApplicationFileDeployment(File applicationDirectory) {
        this(applicationDirectory, DEFAULT_APPLICATION_XML_FILENAME);
    }

    public ApplicationFileDeployment(File applicationDirectoryOrZip, String applicationFileName) {
        this.applicationDirectoryOrZip = applicationDirectoryOrZip;
        this.applicationFileName = applicationFileName;
    }

    public ApplicationConfig create() {
        return ApplicationFileDeployment.readApplication(this.applicationDirectoryOrZip, this.applicationFileName);
    }

    private static ApplicationConfig readApplication(File directoryOrZip, String applicationFile) {
        if (!directoryOrZip.exists()) {
            throw new AdminException("Application " + directoryOrZip.getAbsolutePath() + " does not exist.");
        }
        if (applicationFile.contains("\\") || applicationFile.contains("/")) {
            throw new AdminException("applicationFile " + applicationFile + " cannot be a path");
        }
        ApplicationConfig config = null;
        if (directoryOrZip.isDirectory()) {
            String applicationFilePath = new File(directoryOrZip, applicationFile).getPath();
            try {
                config = ApplicationFileDeployment.readConfigFromXmlFile(applicationFilePath);
            }
            catch (BeansException e) {
                throw new AdminException("Failed to load " + applicationFilePath, e);
            }
        }
        try {
            config = ApplicationFileDeployment.readConfigFromZipFile(directoryOrZip, applicationFile);
        }
        catch (BeansException e) {
            throw new AdminException("Failed to load " + applicationFile + " from " + directoryOrZip, e);
        }
        if (config == null) {
            throw new AdminException("Cannot find an application bean in " + applicationFile + " file.");
        }
        if (config.getJarsDirectoryOrZip() == null) {
            config.setJarsDirectoryOrZip(directoryOrZip);
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ApplicationConfig readConfigFromXmlFile(String applicationFilePath) throws BeansException {
        ApplicationConfig config;
        String fileUri = new File(applicationFilePath).toURI().toString();
        FileSystemXmlApplicationContext context = new FileSystemXmlApplicationContext(fileUri);
        try {
            context.refresh();
            config = (ApplicationConfig)context.getBean(ApplicationConfig.class);
        }
        finally {
            if (context.isActive()) {
                context.close();
            }
        }
        return config;
    }

    private static ApplicationConfig readConfigFromZipFile(File directoryOrZip, String applicationFile) throws BeansException {
        byte[] buffer = FileUtils.unzipFileToMemory((String)applicationFile, (File)directoryOrZip, (long)MAX_XML_FILE_SIZE);
        ByteArrayResource resource = new ByteArrayResource(buffer);
        return ApplicationFileDeployment.getSpringBeanFromResource((Resource)resource, ApplicationConfig.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T getSpringBeanFromResource(Resource resource, Class<T> type) throws BeansException {
        GenericApplicationContext context = new GenericApplicationContext();
        try {
            XmlBeanDefinitionReader xmlReader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)context);
            xmlReader.loadBeanDefinitions(resource);
            context.refresh();
            Object object = context.getBean(type);
            return (T)object;
        }
        finally {
            if (context.isActive()) {
                context.close();
            }
        }
    }
}

