/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.application.config;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.openspaces.admin.pu.topology.ProcessingUnitConfigHolder;
import org.springframework.beans.factory.annotation.Required;

@XmlRootElement(name="application")
public class ApplicationConfig {
    private String name;
    private List<ProcessingUnitConfigHolder> processingUnits = new ArrayList<ProcessingUnitConfigHolder>();
    private File jarsDirectory;

    public String getName() {
        return this.name;
    }

    @Required
    public void setName(String name) {
        this.name = name;
    }

    public ProcessingUnitConfigHolder[] getProcessingUnits() {
        return this.processingUnits.toArray(new ProcessingUnitConfigHolder[this.processingUnits.size()]);
    }

    @XmlElement(type=ProcessingUnitConfigHolder.class)
    public void setProcessingUnits(ProcessingUnitConfigHolder[] processingUnitDeployments) {
        this.processingUnits = new ArrayList<ProcessingUnitConfigHolder>(Arrays.asList(processingUnitDeployments));
    }

    public void addProcessingUnit(ProcessingUnitConfigHolder puConfigFactory) {
        this.processingUnits.add(puConfigFactory);
    }

    public File getJarsDirectoryOrZip() {
        return this.jarsDirectory;
    }

    @XmlTransient
    public void setJarsDirectoryOrZip(File jarsDirectory) {
        this.jarsDirectory = jarsDirectory;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.jarsDirectory == null ? 0 : this.jarsDirectory.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.processingUnits == null ? 0 : this.processingUnits.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ApplicationConfig other = (ApplicationConfig)obj;
        if (this.jarsDirectory == null ? other.jarsDirectory != null : !this.jarsDirectory.equals(other.jarsDirectory)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.processingUnits == null ? other.processingUnits != null : !this.processingUnits.equals(other.processingUnits));
    }

    public String toString() {
        return "ApplicationConfig [" + (this.name != null ? "name=" + this.name + ", " : "") + (this.processingUnits != null ? "processingUnits=" + this.processingUnits + ", " : "") + (this.jarsDirectory != null ? "jarsDirectory=" + this.jarsDirectory : "") + "]";
    }
}

