/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.application.deploy;

import com.gigaspaces.security.directory.CredentialsProvider;
import com.gigaspaces.security.directory.User;
import com.gigaspaces.security.directory.UserDetails;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openspaces.admin.Admin;
import org.openspaces.admin.AdminFactory;
import org.openspaces.admin.gsm.GridServiceManager;
import org.openspaces.pu.container.support.CommandLineParser;

public abstract class AbstractApplicationCommand {
    public static final String KEY_HELP1 = "h";
    public static final String KEY_HELP2 = "help";
    public static final String KEY_GROUPS = "groups";
    public static final String KEY_LOCATORS = "locators";
    public static final String KEY_TIMEOUT = "timeout";
    public static final String KEY_DEPLOY_TIMEOUT = "deploy-timeout";
    public static final String KEY_UNDEPLOY_TIMEOUT = "undeploy-timeout";
    public static final String KEY_USER = "user";
    public static final String KEY_PASSWORD = "password";
    public static final String KEY_SECURED = "secured";
    private final Log logger = LogFactory.getLog(this.getClass());
    private String[] groups;
    private CredentialsProvider credentialsProvider;
    private String locators;
    private int lookupTimeout = 5000;
    private long timeout = Long.MAX_VALUE;
    private boolean sout = false;
    private boolean disableInfoLogging = false;
    private Boolean secured;
    private UserDetails userDetails;
    private boolean managed = false;

    public Boolean getSecured() {
        return this.secured;
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    public void setSecured(Boolean secured) {
        this.secured = secured;
    }

    protected Log getLogger() {
        return this.logger;
    }

    protected String[] getGroups() {
        return this.groups;
    }

    protected String getLocators() {
        return this.locators;
    }

    protected int getLookupTimeout() {
        return this.lookupTimeout;
    }

    protected long getTimeout() {
        return this.timeout;
    }

    protected boolean isSout() {
        return this.sout;
    }

    protected boolean isDisableInfoLogging() {
        return this.disableInfoLogging;
    }

    protected UserDetails getUserDetails() {
        return this.userDetails;
    }

    protected boolean getManaged() {
        return this.managed;
    }

    public void setDisableInfoLogging(boolean disableInfoLogging) {
        this.disableInfoLogging = disableInfoLogging;
    }

    public void setSout(boolean sout) {
        this.sout = sout;
    }

    public void setGroups(String[] groups) {
        this.groups = groups;
    }

    public void setLocators(String locators) {
        this.locators = locators;
    }

    public void setLookupTimeout(int lookupTimeout) {
        this.lookupTimeout = lookupTimeout;
    }

    public void setSecured(boolean secured) {
        this.secured = secured;
    }

    public void setUserDetails(UserDetails userDetails) {
        this.userDetails = userDetails;
    }

    public void setUserDetails(String userName, String password) {
        this.userDetails = new User(userName, password);
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setManaged(boolean managed) {
        this.managed = managed;
    }

    protected void info(String message) {
        if (this.disableInfoLogging) {
            return;
        }
        if (this.sout) {
            System.out.println(message);
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)message);
        }
    }

    protected void debug(String message) {
        if (this.disableInfoLogging) {
            return;
        }
        if (this.logger.isDebugEnabled()) {
            if (this.sout) {
                System.out.println(message);
            }
            this.logger.debug((Object)message);
        }
    }

    protected void parseArgs(String[] args) {
        CommandLineParser.Parameter[] params = CommandLineParser.parse((String[])args, (int)(args.length - 1));
        String username = null;
        String password = null;
        for (CommandLineParser.Parameter param : params) {
            this.debug("parsing param name=" + param.getName() + " args=" + Arrays.toString(param.getArguments()));
            if (param.getName().equalsIgnoreCase(KEY_GROUPS)) {
                this.setGroups(param.getArguments());
            }
            if (param.getName().equalsIgnoreCase(KEY_LOCATORS)) {
                StringBuilder sb = new StringBuilder();
                for (String arg : param.getArguments()) {
                    sb.append(arg).append(',');
                }
                this.setLocators(sb.toString());
            }
            if (param.getName().equalsIgnoreCase(KEY_TIMEOUT)) {
                this.setLookupTimeout(Integer.valueOf(param.getArguments()[0]));
            }
            if (param.getName().equalsIgnoreCase(KEY_DEPLOY_TIMEOUT) || param.getName().equalsIgnoreCase(KEY_UNDEPLOY_TIMEOUT)) {
                this.setTimeout(Long.valueOf(param.getArguments()[0]));
            }
            if (param.getName().equals(KEY_USER)) {
                username = param.getArguments()[0];
            }
            if (param.getName().equals(KEY_PASSWORD)) {
                password = param.getArguments()[0];
            }
            if (!param.getName().equals(KEY_SECURED)) continue;
            if (param.getArguments().length == 0) {
                this.setSecured(true);
                continue;
            }
            this.setSecured(Boolean.parseBoolean(param.getArguments()[0]));
        }
        if (username != null && password != null) {
            this.setUserDetails(username, password);
        }
        this.debug("command line parsing complete: " + this.toString());
    }

    protected GridServiceManager waitForGridServiceManager() throws TimeoutException {
        this.info("Waiting for Grid Service Manager");
        Admin admin = this.createAdmin();
        GridServiceManager gsm = admin.getGridServiceManagers().waitForAtLeastOne(this.lookupTimeout, TimeUnit.MILLISECONDS);
        if (gsm == null) {
            throw new TimeoutException("GSM discovery timed out after " + TimeUnit.SECONDS.convert(this.lookupTimeout, TimeUnit.MILLISECONDS) + " seconds");
        }
        return gsm;
    }

    private Admin createAdmin() {
        AdminFactory adminFactory = new AdminFactory().useDaemonThreads(true);
        if (this.locators != null) {
            adminFactory.addLocators(this.locators);
        }
        if (this.groups != null) {
            for (String group : this.groups) {
                adminFactory.addGroup(group);
            }
        }
        if (this.credentialsProvider != null) {
            adminFactory.credentialsProvider(this.credentialsProvider);
        }
        Admin admin = adminFactory.create();
        return admin;
    }

    public String toString() {
        return this.getClass().getName() + " [" + (this.groups != null ? "groups=" + Arrays.toString(this.groups) + ", " : "") + (this.credentialsProvider != null ? "credentialsProvider=" + this.credentialsProvider + ", " : "") + (this.locators != null ? "locators=" + this.locators + ", " : "") + "lookupTimeout=" + this.lookupTimeout + ", timeout=" + this.timeout + ", sout=" + this.sout + ", disableInfoLogging=" + this.disableInfoLogging + ", " + (this.secured != null ? "secured=" + this.secured + ", " : "") + (this.userDetails != null ? "userDetails=" + this.userDetails + ", " : "") + "managed=" + this.managed + "]";
    }
}

