/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.application.deploy;

import com.gigaspaces.time.SystemTime;
import java.io.File;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.openspaces.admin.AdminException;
import org.openspaces.admin.application.Application;
import org.openspaces.admin.application.ApplicationFileDeployment;
import org.openspaces.admin.application.config.ApplicationConfig;
import org.openspaces.admin.application.deploy.AbstractApplicationCommand;
import org.openspaces.admin.gsm.GridServiceManager;
import org.openspaces.admin.pu.ProcessingUnit;
import org.openspaces.admin.pu.config.UserDetailsConfig;
import org.openspaces.admin.pu.topology.ProcessingUnitConfigHolder;

public class ApplicationDeployCommand
extends AbstractApplicationCommand {
    public static final String[] validOptionsArray = new String[]{"h", "help", "user", "password", "secured", "groups", "locators", "timeout", "deploy-timeout"};

    public static void main(String[] args) throws Exception {
        ApplicationDeployCommand deployer = new ApplicationDeployCommand();
        if (args.length < 1) {
            System.out.println(deployer.getUsage());
            return;
        }
        try {
            deployer.deployAndWait(args);
        }
        catch (TimeoutException e) {
            System.exit(1);
        }
    }

    public void deployAndWait(String[] args) throws TimeoutException, AdminException {
        try {
            this.parseArgs(args);
            GridServiceManager gsm = this.waitForGridServiceManager();
            File applicationFolder = new File(args[args.length - 1]);
            long end = SystemTime.timeMillis() + this.getTimeout();
            ApplicationConfig applicationConfig = new ApplicationFileDeployment(applicationFolder).create();
            for (ProcessingUnitConfigHolder puConfig : applicationConfig.getProcessingUnits()) {
                if (this.getSecured() != null) {
                    puConfig.setSecured(this.getSecured());
                }
                if (this.getUserDetails() == null) continue;
                UserDetailsConfig userDetailsConfig = new UserDetailsConfig();
                userDetailsConfig.setUsername(this.getUserDetails().getUsername());
                userDetailsConfig.setPassword(this.getUserDetails().getPassword());
                puConfig.setUserDetails(userDetailsConfig);
            }
            String name = applicationConfig.getName();
            this.info("Deploying application " + name);
            Application dataApp = gsm.deploy(applicationConfig);
            for (ProcessingUnit pu : dataApp.getProcessingUnits()) {
                long remaining = end - SystemTime.timeMillis();
                if (remaining >= 0L && pu.waitFor(pu.getTotalNumberOfInstances(), remaining, TimeUnit.MILLISECONDS)) continue;
                throw new TimeoutException("Application " + name + " deployment timed out after " + TimeUnit.SECONDS.convert(this.getTimeout(), TimeUnit.MILLISECONDS) + " seconds");
            }
            this.info(name + " deployment completed successfully.");
        }
        catch (TimeoutException e) {
            this.info(e.getMessage());
            throw e;
        }
    }

    public String getUsage() {
        StringBuilder sb = new StringBuilder();
        if (!this.getManaged()) {
            sb.append("Usage: ApplicationDeployCommand [-groups groups] [-locators hots1 hots2] [-timeout timeoutValue] [-user xxx -password yyy] [-secured true/false] Application_DirOrZip");
        } else {
            sb.append("Usage: deploy-application [-user xxx -password yyy] [-secured true/false] Application_DirOrZip");
        }
        sb.append("\n    Application_DirOrZip: The path to the application directory or zip file containing application.xml and the PU jars.");
        if (!this.getManaged()) {
            sb.append("\n    -groups [groupName] [groupName] ...      : The lookup groups used to look up the GSM");
            sb.append("\n    -locators [host1] [host2] ...            : The lookup locators used to look up the GSM");
            sb.append("\n    -timeout [timeout value]                 : The timeout value of GSM lookup (defaults to 5000) in milliseconds");
        }
        sb.append("\n    -user xxx -password yyyy                 : Deploys a secured processing unit propagated with the supplied user and password");
        sb.append("\n    -secured true                            : Deploys a secured processing unit (implicit when using -user/-password)");
        sb.append("\n    -deploy-timeout [timeout value in ms]    : Timeout for deploy operation, otherwise blocks until all successful/failed deployment events arrive (default)");
        sb.append("\n");
        sb.append("\n");
        sb.append("\nSome Examples:");
        if (!this.getManaged()) {
            sb.append("\n1. ApplicationDeployCommand examples/data/dist");
        } else {
            sb.append("\n1. deploy-application examples/data/dist");
        }
        sb.append("\n    - Deploys the application in the data-app directory.");
        if (!this.getManaged()) {
            sb.append("\n1. ApplicationDeployCommand examples/data/dist.zip");
        } else {
            sb.append("\n1. deploy-application examples/data/dist.zip");
        }
        sb.append("\n    - Deploys the application in the data-app zip file.");
        return sb.toString();
    }
}

