/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.application.deploy;

import com.gigaspaces.time.SystemTime;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.openspaces.admin.Admin;
import org.openspaces.admin.application.Application;
import org.openspaces.admin.application.deploy.AbstractApplicationCommand;
import org.openspaces.admin.gsm.GridServiceManager;

public class ApplicationUndeployCommand
extends AbstractApplicationCommand {
    public static final String[] validOptionsArray = new String[]{"h", "help", "user", "password", "secured", "groups", "locators", "timeout", "undeploy-timeout"};

    public static void main(String[] args) throws Exception {
        ApplicationUndeployCommand deployer = new ApplicationUndeployCommand();
        if (args.length < 1) {
            System.out.println(deployer.getUsage());
            return;
        }
        try {
            deployer.undeployAndWait(args);
        }
        catch (TimeoutException e) {
            System.exit(1);
        }
    }

    public void undeployAndWait(String[] args) throws TimeoutException {
        try {
            this.parseArgs(args);
            GridServiceManager gsm = this.waitForGridServiceManager();
            String name = args[args.length - 1];
            long end = SystemTime.timeMillis() + this.getTimeout();
            Application application = this.waitForApplication(gsm.getAdmin(), name, this.getTimeout(), TimeUnit.MILLISECONDS);
            this.info("Undeploying application " + name);
            long remaining = this.remainingMilliseconds(name, end);
            application.undeployAndWait(remaining, TimeUnit.MILLISECONDS);
            this.info(name + " has been successfully undeployed.");
        }
        catch (TimeoutException e) {
            this.info(e.getMessage());
            throw e;
        }
    }

    private Application waitForApplication(Admin admin, String name, long timeout, TimeUnit timeunit) throws TimeoutException {
        Application application = admin.getApplications().waitFor(name, timeout, timeunit);
        if (application == null) {
            throw new TimeoutException("Application " + name + " discovery timed-out. Check if application is deployed.");
        }
        return application;
    }

    private long remainingMilliseconds(String name, long end) throws TimeoutException {
        long remaining = end - SystemTime.timeMillis();
        if (remaining < 0L) {
            throw new TimeoutException("Application " + name + " undeployment timed out");
        }
        return remaining;
    }

    public String getUsage() {
        StringBuilder sb = new StringBuilder();
        if (!this.getManaged()) {
            sb.append("Usage: ApplicationUndeployCommand [-groups groups] [-locators hots1 hots2] [-timeout timeoutValue] [-user xxx -password yyy] [-secured true/false] Application_Name");
        } else {
            sb.append("Usage: undeploy-application [-user xxx -password yyy] [-secured true/false] Application_Name");
        }
        sb.append("\n    Application_Name: The path to the application directory or zip file containing application.xml and the PU jars.");
        if (!this.getManaged()) {
            sb.append("\n    -groups [groupName] [groupName] ...      : The lookup groups used to look up the GSM");
            sb.append("\n    -locators [host1] [host2] ...            : The lookup locators used to look up the GSM");
            sb.append("\n    -timeout [timeout value]                 : The timeout value of GSM lookup (defaults to 5000) in milliseconds");
        }
        sb.append("\n    -user xxx -password yyyy                 : Deploys a secured processing unit propagated with the supplied user and password");
        sb.append("\n    -secured true                            : Deploys a secured processing unit (implicit when using -user/-password)");
        sb.append("\n    -undeploy-timeout [timeout value in ms]    : Timeout for undeploy operation, otherwise blocks until all successful/failed deployment events arrive (default)");
        sb.append("\n");
        sb.append("\n");
        sb.append("\nSome Examples:");
        sb.append("\n1. Undeploy data-app");
        sb.append("\n    - Undeploys the data-app application.");
        return sb.toString();
    }
}

