/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.dump;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openspaces.admin.AdminException;
import org.openspaces.admin.dump.DumpDownloadListener;
import org.openspaces.admin.dump.DumpResult;

public class CompoundDumpResult
implements DumpResult {
    private static final Log logger = LogFactory.getLog(CompoundDumpResult.class);
    private List<DumpResult> dumpResults = new CopyOnWriteArrayList<DumpResult>();
    private List<File> dumpFiles = new ArrayList<File>(2);

    public CompoundDumpResult add(DumpResult dumpResult) {
        this.dumpResults.add(dumpResult);
        return this;
    }

    @Override
    public String getName() {
        StringBuilder sb = new StringBuilder();
        for (DumpResult dumpResult : this.dumpResults) {
            sb.append(dumpResult.getName()).append(",");
        }
        return sb.toString();
    }

    public DumpResult[] getResults() {
        return this.dumpResults.toArray(new DumpResult[this.dumpResults.size()]);
    }

    @Override
    public long downloadSize() {
        long downloadSize = 0L;
        for (DumpResult dumpResult : this.dumpResults) {
            downloadSize += dumpResult.downloadSize();
        }
        return downloadSize;
    }

    @Override
    public void download(File targetDirectory, String fileName, DumpDownloadListener listener) throws AdminException {
        if (!fileName.endsWith(".zip")) {
            fileName = fileName + ".zip";
        }
        File zipFile = new File(targetDirectory, fileName);
        this.download(zipFile, listener);
    }

    @Override
    public void download(File target, DumpDownloadListener listener) throws AdminException {
        try {
            ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(target));
            for (DumpResult dumpResult : this.dumpResults) {
                dumpResult.download(zos, listener);
                if (!(dumpResult instanceof CompoundDumpResult)) continue;
                ((CompoundDumpResult)dumpResult).writeDumpFilesToZip(zos);
            }
            this.writeDumpFilesToZip(zos);
            zos.close();
        }
        catch (IOException e) {
            throw new AdminException("Failed to download", e);
        }
    }

    void writeDumpFilesToZip(ZipOutputStream zos) {
        for (File dumpFile : this.dumpFiles) {
            try {
                int length;
                zos.putNextEntry(new ZipEntry(dumpFile.getName()));
                FileInputStream fis = new FileInputStream(dumpFile);
                byte[] buffer = new byte[1024];
                while ((length = fis.read(buffer)) > 0) {
                    zos.write(buffer, 0, length);
                }
                zos.closeEntry();
                fis.close();
            }
            catch (IOException ioe) {
                if (!logger.isErrorEnabled()) continue;
                logger.error((Object)ioe.toString(), (Throwable)ioe);
            }
        }
    }

    @Override
    public void download(ZipOutputStream zos, DumpDownloadListener listener) throws IOException {
        try {
            for (DumpResult dumpResult : this.dumpResults) {
                dumpResult.download(zos, listener);
            }
        }
        catch (IOException e) {
            throw new AdminException("Failed to download", e);
        }
    }

    public void addDumpFile(File file) {
        this.dumpFiles.add(file);
    }
}

