/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.gateway.events;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openspaces.admin.gateway.Gateway;
import org.openspaces.admin.gateway.Gateways;
import org.openspaces.admin.gateway.events.ClosureGatewayAddedEventListener;
import org.openspaces.admin.gateway.events.GatewayAddedEventListener;
import org.openspaces.admin.gateway.events.InternalGatewayAddedEventManager;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.support.GroovyHelper;

public class DefaultGatewayAddedEventManager
implements InternalGatewayAddedEventManager {
    private final Gateways gateways;
    private final InternalAdmin admin;
    private final List<GatewayAddedEventListener> listeners = new CopyOnWriteArrayList<GatewayAddedEventListener>();

    public DefaultGatewayAddedEventManager(Gateways gateways) {
        this.gateways = gateways;
        this.admin = (InternalAdmin)gateways.getAdmin();
    }

    @Override
    public void gatewayAdded(final Gateway gateway) {
        for (final GatewayAddedEventListener listener : this.listeners) {
            this.admin.pushScheduleMonitorCorrelatedEvent(listener, new Runnable(){

                @Override
                public void run() {
                    listener.gatewayAdded(gateway);
                }
            });
        }
    }

    @Override
    public void add(GatewayAddedEventListener eventListener) {
        this.add(eventListener, true);
    }

    @Override
    public void add(final GatewayAddedEventListener eventListener, boolean includeExisting) {
        if (includeExisting) {
            this.admin.raiseEvent(eventListener, new Runnable(){

                @Override
                public void run() {
                    for (Gateway gateway : DefaultGatewayAddedEventManager.this.gateways) {
                        eventListener.gatewayAdded(gateway);
                    }
                }
            });
        }
        this.listeners.add(eventListener);
    }

    @Override
    public void remove(GatewayAddedEventListener eventListener) {
        this.listeners.remove(eventListener);
    }

    public void plus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.add(new ClosureGatewayAddedEventListener(eventListener));
        } else {
            this.add((GatewayAddedEventListener)eventListener);
        }
    }

    public void leftShift(Object eventListener) {
        this.plus(eventListener);
    }

    public void minus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.remove(new ClosureGatewayAddedEventListener(eventListener));
        } else {
            this.remove((GatewayAddedEventListener)eventListener);
        }
    }

    public void rightShift(Object eventListener) {
        this.minus(eventListener);
    }
}

