/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.gateway.events;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openspaces.admin.gateway.GatewayProcessingUnit;
import org.openspaces.admin.gateway.GatewayProcessingUnits;
import org.openspaces.admin.gateway.events.ClosureGatewayProcessingUnitAddedEventListener;
import org.openspaces.admin.gateway.events.GatewayProcessingUnitAddedEventListener;
import org.openspaces.admin.gateway.events.InternalGatewayProcessingUnitAddedEventManager;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.support.GroovyHelper;

public class DefaultGatewayProcessingUnitAddedEventManager
implements InternalGatewayProcessingUnitAddedEventManager {
    private final GatewayProcessingUnits gatewayProcessingUnits;
    private final InternalAdmin admin;
    private final List<GatewayProcessingUnitAddedEventListener> listeners = new CopyOnWriteArrayList<GatewayProcessingUnitAddedEventListener>();

    public DefaultGatewayProcessingUnitAddedEventManager(GatewayProcessingUnits gatewayProcessingUnits) {
        this.gatewayProcessingUnits = gatewayProcessingUnits;
        this.admin = (InternalAdmin)gatewayProcessingUnits.getAdmin();
    }

    @Override
    public void gatewayProcessingUnitAdded(final GatewayProcessingUnit gatewayProcessingUnit) {
        for (final GatewayProcessingUnitAddedEventListener listener : this.listeners) {
            this.admin.pushScheduleMonitorCorrelatedEvent(listener, new Runnable(){

                @Override
                public void run() {
                    listener.gatewayProcessingUnitAdded(gatewayProcessingUnit);
                }
            });
        }
    }

    @Override
    public void add(GatewayProcessingUnitAddedEventListener eventListener) {
        this.add(eventListener, true);
    }

    @Override
    public void add(final GatewayProcessingUnitAddedEventListener eventListener, boolean includeExisting) {
        if (includeExisting) {
            this.admin.raiseEvent(eventListener, new Runnable(){

                @Override
                public void run() {
                    for (GatewayProcessingUnit gatewayProcessingUnit : DefaultGatewayProcessingUnitAddedEventManager.this.gatewayProcessingUnits) {
                        eventListener.gatewayProcessingUnitAdded(gatewayProcessingUnit);
                    }
                }
            });
        }
        this.listeners.add(eventListener);
    }

    @Override
    public void remove(GatewayProcessingUnitAddedEventListener eventListener) {
        this.listeners.remove(eventListener);
    }

    public void plus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.add(new ClosureGatewayProcessingUnitAddedEventListener(eventListener));
        } else {
            this.add((GatewayProcessingUnitAddedEventListener)eventListener);
        }
    }

    public void leftShift(Object eventListener) {
        this.plus(eventListener);
    }

    public void minus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.remove(new ClosureGatewayProcessingUnitAddedEventListener(eventListener));
        } else {
            this.remove((GatewayProcessingUnitAddedEventListener)eventListener);
        }
    }

    public void rightShift(Object eventListener) {
        this.minus(eventListener);
    }
}

