/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.gateway.events;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openspaces.admin.gateway.GatewayProcessingUnit;
import org.openspaces.admin.gateway.GatewayProcessingUnits;
import org.openspaces.admin.gateway.events.ClosureGatewayProcessingUnitRemovedEventListener;
import org.openspaces.admin.gateway.events.GatewayProcessingUnitRemovedEventListener;
import org.openspaces.admin.gateway.events.InternalGatewayProcessingUnitRemovedEventManager;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.support.GroovyHelper;

public class DefaultGatewayProcessingUnitRemovedEventManager
implements InternalGatewayProcessingUnitRemovedEventManager {
    private final GatewayProcessingUnits gatewayProcessingUnits;
    private final InternalAdmin admin;
    private final List<GatewayProcessingUnitRemovedEventListener> listeners = new CopyOnWriteArrayList<GatewayProcessingUnitRemovedEventListener>();

    public DefaultGatewayProcessingUnitRemovedEventManager(GatewayProcessingUnits processingUnits) {
        this.gatewayProcessingUnits = processingUnits;
        this.admin = (InternalAdmin)processingUnits.getAdmin();
    }

    @Override
    public void gatewayProcessingUnitRemoved(final GatewayProcessingUnit gatewayProcessingUnit) {
        for (final GatewayProcessingUnitRemovedEventListener listener : this.listeners) {
            this.admin.pushScheduleMonitorCorrelatedEvent(listener, new Runnable(){

                @Override
                public void run() {
                    listener.gatewayProcessingUnitRemoved(gatewayProcessingUnit);
                }
            });
        }
    }

    @Override
    public void add(GatewayProcessingUnitRemovedEventListener eventListener) {
        this.listeners.add(eventListener);
    }

    @Override
    public void remove(GatewayProcessingUnitRemovedEventListener eventListener) {
        this.listeners.remove(eventListener);
    }

    public void plus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.add(new ClosureGatewayProcessingUnitRemovedEventListener(eventListener));
        } else {
            this.add((GatewayProcessingUnitRemovedEventListener)eventListener);
        }
    }

    public void leftShift(Object eventListener) {
        this.plus(eventListener);
    }

    public void minus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.remove(new ClosureGatewayProcessingUnitRemovedEventListener(eventListener));
        } else {
            this.remove((GatewayProcessingUnitRemovedEventListener)eventListener);
        }
    }

    public void rightShift(Object eventListener) {
        this.minus(eventListener);
    }
}

