/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.gateway.events;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openspaces.admin.gateway.Gateway;
import org.openspaces.admin.gateway.Gateways;
import org.openspaces.admin.gateway.events.ClosureGatewayRemovedEventListener;
import org.openspaces.admin.gateway.events.GatewayRemovedEventListener;
import org.openspaces.admin.gateway.events.InternalGatewayRemovedEventManager;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.support.GroovyHelper;

public class DefaultGatewayRemovedEventManager
implements InternalGatewayRemovedEventManager {
    private final Gateways gateways;
    private final InternalAdmin admin;
    private final List<GatewayRemovedEventListener> listeners = new CopyOnWriteArrayList<GatewayRemovedEventListener>();

    public DefaultGatewayRemovedEventManager(Gateways gateways) {
        this.gateways = gateways;
        this.admin = (InternalAdmin)gateways.getAdmin();
    }

    @Override
    public void gatewayRemoved(final Gateway gateway) {
        for (final GatewayRemovedEventListener listener : this.listeners) {
            this.admin.pushScheduleMonitorCorrelatedEvent(listener, new Runnable(){

                @Override
                public void run() {
                    listener.gatewayRemoved(gateway);
                }
            });
        }
    }

    @Override
    public void add(GatewayRemovedEventListener eventListener) {
        this.listeners.add(eventListener);
    }

    @Override
    public void remove(GatewayRemovedEventListener eventListener) {
        this.listeners.remove(eventListener);
    }

    public void plus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.add(new ClosureGatewayRemovedEventListener(eventListener));
        } else {
            this.add((GatewayRemovedEventListener)eventListener);
        }
    }

    public void leftShift(Object eventListener) {
        this.plus(eventListener);
    }

    public void minus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.remove(new ClosureGatewayRemovedEventListener(eventListener));
        } else {
            this.remove((GatewayRemovedEventListener)eventListener);
        }
    }

    public void rightShift(Object eventListener) {
        this.minus(eventListener);
    }
}

