/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.gsa;

import com.gigaspaces.grid.gsa.GSProcessOptions;
import com.gigaspaces.grid.gsa.GSProcessRestartOnExit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GridServiceContainerOptions {
    private final List<String> vmInputArguments = new ArrayList<String>();
    private boolean overrideVmInputArguments = false;
    private boolean useScript = false;
    private final Map<String, String> environmentVariables = new HashMap<String, String>();
    private GSProcessRestartOnExit restartOnExit;

    public GridServiceContainerOptions useScript() {
        this.useScript = true;
        return this;
    }

    public GridServiceContainerOptions overrideVmInputArguments() {
        this.overrideVmInputArguments = true;
        return this;
    }

    public GridServiceContainerOptions vmInputArgument(String vmInputArgument) {
        this.vmInputArguments.add(vmInputArgument);
        return this;
    }

    public GridServiceContainerOptions environmentVariable(String name, String value) {
        this.environmentVariables.put(name, value);
        return this;
    }

    public GridServiceContainerOptions restartOnExit(GSProcessRestartOnExit restartOnExit) {
        this.restartOnExit = restartOnExit;
        return this;
    }

    public GSProcessOptions getOptions() {
        GSProcessOptions options = new GSProcessOptions("gsc");
        options.setUseScript(this.useScript);
        if (this.overrideVmInputArguments) {
            options.setVmInputArguments(this.vmInputArguments.toArray(new String[this.vmInputArguments.size()]));
        } else {
            options.setVmAppendableInputArguments(this.vmInputArguments.toArray(new String[this.vmInputArguments.size()]));
        }
        options.setEnvironmentVariables(this.environmentVariables);
        options.setRestartOnExit(this.restartOnExit);
        return options;
    }

    public boolean equals(Object other) {
        return other instanceof GridServiceContainerOptions && ((GridServiceContainerOptions)other).useScript == this.useScript && ((GridServiceContainerOptions)other).overrideVmInputArguments == this.overrideVmInputArguments && ((GridServiceContainerOptions)other).vmInputArguments.equals(this.vmInputArguments) && ((GridServiceContainerOptions)other).environmentVariables.equals(this.environmentVariables) && ((GridServiceContainerOptions)other).restartOnExit == this.restartOnExit;
    }
}

