/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.gsa;

import com.gigaspaces.grid.gsa.GSProcessOptions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GridServiceOptions {
    private final String type;
    private boolean useScript = false;
    private final List<String> vmInputArguments = new ArrayList<String>();
    private boolean overrideVmInputArguments = false;
    private final List<String> arguments = new ArrayList<String>();
    private boolean overrideArguments;
    private final Map<String, String> environmentVariables = new HashMap<String, String>();

    public GridServiceOptions(String type) {
        this.type = type;
    }

    public GridServiceOptions useScript() {
        this.useScript = true;
        return this;
    }

    public GridServiceOptions overrideVmInputArguments() {
        this.overrideVmInputArguments = true;
        return this;
    }

    public GridServiceOptions vmInputArgument(String vmInputArgument) {
        this.vmInputArguments.add(vmInputArgument);
        return this;
    }

    public GridServiceOptions overrideArguments() {
        this.overrideArguments = true;
        return this;
    }

    public GridServiceOptions argument(String argument) {
        this.arguments.add(argument);
        return this;
    }

    public GridServiceOptions environmentVariable(String name, String value) {
        this.environmentVariables.put(name, value);
        return this;
    }

    public GSProcessOptions getOptions() {
        GSProcessOptions options = new GSProcessOptions(this.type);
        options.setUseScript(this.useScript);
        if (this.overrideVmInputArguments) {
            options.setVmInputArguments(this.vmInputArguments.toArray(new String[this.vmInputArguments.size()]));
        } else {
            options.setVmAppendableInputArguments(this.vmInputArguments.toArray(new String[this.vmInputArguments.size()]));
        }
        if (options.isUseScript()) {
            if (this.overrideArguments) {
                options.setScriptArguments(this.arguments.toArray(new String[this.arguments.size()]));
            } else {
                options.setScriptAppendableArguments(this.arguments.toArray(new String[this.arguments.size()]));
            }
        } else if (this.overrideArguments) {
            options.setVmArguments(this.arguments.toArray(new String[this.arguments.size()]));
        } else {
            options.setVmAppendableArguments(this.arguments.toArray(new String[this.arguments.size()]));
        }
        options.setEnvironmentVariables(this.environmentVariables);
        return options;
    }
}

